#include <string>
#include <sl/object.hpp>


BOOST_AUTO_TEST_CASE(operator_equal_test)
{
    sl::object o1(1);
    sl::object o2(2);
    sl::object o3(3);
    BOOST_CHECK_EQUAL(sl::object_cast<int>(o1), 1);
    BOOST_CHECK_EQUAL(sl::object_cast<int>(o2), 2);
    BOOST_CHECK_EQUAL(sl::object_cast<int>(o3), 3);

    o1 = o2;
    BOOST_CHECK_EQUAL(sl::object_cast<int>(o1), 2);
    o1 = o3;
    BOOST_CHECK_EQUAL(sl::object_cast<int>(o1), 3);
    o3 = o2 = o1;
    BOOST_CHECK_EQUAL(sl::object_cast<int>(o1), 3);
    BOOST_CHECK_EQUAL(sl::object_cast<int>(o2), 3);
    BOOST_CHECK_EQUAL(sl::object_cast<int>(o3), 3);

    sl::object o4("1234567890");
    o1 = o4;
    BOOST_CHECK_EQUAL(sl::object_cast<std::string>(o1), "1234567890");
    BOOST_CHECK_EQUAL(sl::object_cast<std::string>(o1),
                      sl::object_cast<std::string>(o4));
}


BOOST_AUTO_TEST_CASE(operator_bool_test)
{
    sl::object o1;
    sl::object o2(1);
    sl::object o3(std::string("1234567890"));
    sl::object o4(new double(1.0));

    BOOST_CHECK_EQUAL(false, o1);
    BOOST_CHECK_EQUAL(true, o2);
    BOOST_CHECK_EQUAL(true, o3);
    BOOST_CHECK_EQUAL(true, o4);
}


BOOST_AUTO_TEST_CASE(other_memfun_test)
{
    sl::object o1;
    sl::object o2(1);
    sl::object o3(1.0);
    sl::object o4(std::string("1234567890"));
    sl::object o5(new int(10));

    BOOST_CHECK_EQUAL(o1.to_string(), "");
    BOOST_CHECK_EQUAL(o2.to_string(), "int");
    BOOST_CHECK_EQUAL(o3.to_string(), "double");
    BOOST_CHECK_EQUAL(o4.to_string(), "std::string");

    BOOST_CHECK( ! o1.instanceof<int>());
    BOOST_CHECK( ! o1.instanceof<bool>());
    BOOST_CHECK( ! o1.instanceof<std::string>());

    BOOST_CHECK(o2.instanceof<int>());
    BOOST_CHECK( ! o2.instanceof<int*>());
    BOOST_CHECK(o2.instanceof<int&>());

    BOOST_CHECK(o3.instanceof<double>());
    BOOST_CHECK( ! o3.instanceof<float>());
    BOOST_CHECK( ! o3.instanceof<int>());

    BOOST_CHECK(o4.instanceof<std::string>());
    BOOST_CHECK( ! o4.instanceof<int>());
    BOOST_CHECK(o4.instanceof<const char*>());

    BOOST_CHECK(o5.instanceof<int>());
    BOOST_CHECK(o5.instanceof<int*>());
    BOOST_CHECK(o5.instanceof<int&>());

	sl::object o6(int(1));
	sl::object o7(std::string("ABC"));
	sl::object o8(o7);

	BOOST_CHECK( ! o6.equals(o7));
	BOOST_CHECK(o7.equals(o8));
}
