#include <string>
#include <sl/object.hpp>

class Base {
public :
    virtual std::string name() const
    {
        return "Base";
    }
};

class Derived : public Base {
public :
    virtual std::string name() const
    {
        return "Derived";
    }
};


class BaseObject : public sl::objectable {
public :
    virtual std::string name() const
    {
        return "BaseObject";
    }
};

class DerivedObject : public BaseObject {
public :
    virtual std::string name() const
    {
        return "DerivedObject";
    }
};


BOOST_AUTO_TEST_CASE(inherited_test)
{
    sl::object o1(new Derived());

//  NG bad_cast.
//  Base& b = sl::object_cast<Base>(o1);
    BOOST_CHECK_THROW(sl::object_cast<Base>(o1), std::bad_cast);

    Derived& d1 = sl::object_cast<Derived>(o1);
    BOOST_CHECK_EQUAL(d1.name(), "Derived");

    sl::object o2(new DerivedObject());
    BaseObject& b1 = sl::object_cast<BaseObject>(o2);
    BOOST_CHECK_EQUAL(b1.name(), "DerivedObject");

    BaseObject *b2 = new DerivedObject();
    sl::object o3(b2);
    BaseObject& b3 = sl::object_cast<BaseObject>(o3);
    BOOST_CHECK_EQUAL(b3.name(), "DerivedObject");
}
