#include <string>
#include <sl/object.hpp>

void int_object_param_func(sl::object& o)
{
    BOOST_CHECK_EQUAL(sl::object_cast<int>(o), 12345);
}

void str_object_param_func(sl::object& o)
{
    BOOST_CHECK_EQUAL(sl::object_cast<std::string>(o), "abcdefg");
}

void int_object_param_func(const sl::object& o)
{
    BOOST_CHECK_EQUAL(sl::object_cast<int>(o), 67890);
}

void str_object_param_func(const sl::object& o)
{
    BOOST_CHECK_EQUAL(sl::object_cast<std::string>(o), "hijklm");
}


BOOST_AUTO_TEST_CASE(func_param_test)
{
    sl::object o1(12345);
    sl::object o2("abcdefg");
    int_object_param_func(o1);          // int_object_param_func ...
    str_object_param_func(o2);          // str_object_param_func ...

    int_object_param_func(67890);       // const int_object_param_func 
    str_object_param_func("hijklm");    // const str_object_param_func
}
