#include <string>
#include <sl/object.hpp>


BOOST_AUTO_TEST_CASE(interger_cast_test)
{
    sl::object o1(1); /* default type is int */

    int i1 = sl::object_cast<int>(o1);
    BOOST_CHECK_EQUAL(i1, 1);

    int& i2 = sl::object_cast<int>(o1);
    BOOST_CHECK_EQUAL(i2, 1);
    i2++; ++i2; i2 += 1;
    BOOST_CHECK_EQUAL(i2, 4);

    int i3 = sl::object_cast<int>(o1);
    BOOST_CHECK_EQUAL(i3, 4);
    BOOST_CHECK_EQUAL(i2, i3);

    int* i4 = new int(5);
    sl::object o2(i4);

    int& i5 = sl::object_cast<int>(o2);
    BOOST_CHECK_EQUAL(i5, 5);

    i5 += 1;
    BOOST_CHECK_EQUAL(*i4, 6);
    BOOST_CHECK_EQUAL(i5, 6);
    BOOST_CHECK_EQUAL(*i4, i5);

    BOOST_CHECK_THROW(sl::object_cast<short>(o1), std::bad_cast);
    BOOST_CHECK_THROW(sl::object_cast<char>(o1), std::bad_cast);
    BOOST_CHECK_THROW(sl::object_cast<double>(o1), std::bad_cast);
    BOOST_CHECK_THROW(sl::object_cast<std::string>(o1), std::bad_cast);
    BOOST_CHECK_THROW(sl::object_cast<int*>(o1), std::bad_cast);
    BOOST_CHECK_THROW(sl::object_cast<bool>(o1), std::bad_cast);

    sl::object o3(short(2));
    short s1 = sl::object_cast<short>(o3);
    BOOST_CHECK_EQUAL(s1, 2);

    sl::object o4(char(3));
    char c1 = sl::object_cast<char>(o4);
    BOOST_CHECK_EQUAL(c1, 3);
}


BOOST_AUTO_TEST_CASE(double_cast_test)
{
    sl::object o1(1.0); /* default type is double */

    double d1 = sl::object_cast<double>(o1);
    //BOOST_CHECK_EQUAL(d1, 1.0);

    // double type pointer .
    double* d2 = new double(2.0);
    sl::object o2(d2);

    double& d3 = sl::object_cast<double>(o2);
    BOOST_CHECK_EQUAL(d3, 2.0);

    d3 += 1.0;
    BOOST_CHECK_EQUAL(*d2, 3.0);
    BOOST_CHECK_EQUAL(d3, 3.0);

    BOOST_CHECK_THROW(sl::object_cast<float>(o1), std::bad_cast);
    BOOST_CHECK_THROW(sl::object_cast<int>(o1), std::bad_cast);
    BOOST_CHECK_THROW(sl::object_cast<short>(o1), std::bad_cast);
    BOOST_CHECK_THROW(sl::object_cast<char>(o1), std::bad_cast);
    BOOST_CHECK_THROW(sl::object_cast<std::string>(o1), std::bad_cast);
}


BOOST_AUTO_TEST_CASE(string_cast_test)
{
    sl::object o1("abcdefthijklmnopqrstuvwxyz");
    BOOST_CHECK_EQUAL(sl::object_cast<const char*>(o1),
                      "abcdefthijklmnopqrstuvwxyz");
    BOOST_CHECK_EQUAL(sl::object_cast<std::string>(o1),
                      "abcdefthijklmnopqrstuvwxyz");

    sl::object o2(std::string("abcdefthijklmnopqrstuvwxyz"));
    BOOST_CHECK_EQUAL(sl::object_cast<const char*>(o2),
                      "abcdefthijklmnopqrstuvwxyz");
    BOOST_CHECK_EQUAL(sl::object_cast<std::string>(o2),
                      "abcdefthijklmnopqrstuvwxyz");

    BOOST_CHECK_THROW(sl::object_cast<float>(o1), std::bad_cast);
    BOOST_CHECK_THROW(sl::object_cast<int>(o1), std::bad_cast);
    BOOST_CHECK_THROW(sl::object_cast<short>(o1), std::bad_cast);
    BOOST_CHECK_THROW(sl::object_cast<char>(o1), std::bad_cast);
}


BOOST_AUTO_TEST_CASE(pointer_cast_test)
{
    sl::object o1(1);
    sl::object o2(new double(1.0));
    sl::object o3(std::string("abcdefg"));

    int* i1 = sl::object_pointer_cast<int>(o1);
    BOOST_CHECK_EQUAL(*i1, 1);
    *i1 += 1;
    (*i1)++;
    int* i2 = sl::object_pointer_cast<int>(o1);
    BOOST_CHECK_EQUAL(*i2, 3);

    double* d1 = sl::object_pointer_cast<double>(o2);
    BOOST_CHECK_EQUAL(*d1, 1.0);
    *d1 += 1.0;
    double* d2 = sl::object_pointer_cast<double>(o2);
    BOOST_CHECK_EQUAL(*d2, 2.0);

    std::string* s1 = sl::object_pointer_cast<std::string>(o3);
    BOOST_CHECK_EQUAL(*s1, "abcdefg");
    *s1 += "hijklmn";
    std::string* s2 = sl::object_pointer_cast<std::string>(o3);
    BOOST_CHECK_EQUAL(*s2, "abcdefghijklmn");

    BOOST_CHECK_EQUAL(sl::object_pointer_cast<char>(o1), (char*)0);
    BOOST_CHECK_EQUAL(sl::object_pointer_cast<short>(o1), (short*)0);
    BOOST_CHECK_EQUAL(sl::object_pointer_cast<long>(o1), (long*)0);
    BOOST_CHECK_EQUAL(sl::object_pointer_cast<float>(o1), (float*)0);
    BOOST_CHECK_EQUAL(sl::object_pointer_cast<double>(o1), (double*)0);
    BOOST_CHECK_EQUAL(sl::object_pointer_cast<std::string>(o1),(std::string*)0);

    BOOST_CHECK_EQUAL(sl::object_pointer_cast<char>(o2), (char*)0);
    BOOST_CHECK_EQUAL(sl::object_pointer_cast<short>(o2), (short*)0);
    BOOST_CHECK_EQUAL(sl::object_pointer_cast<int>(o2), (int*)0);
    BOOST_CHECK_EQUAL(sl::object_pointer_cast<long>(o2), (long*)0);
    BOOST_CHECK_EQUAL(sl::object_pointer_cast<float>(o2), (float*)0);
    BOOST_CHECK_EQUAL(sl::object_pointer_cast<std::string>(o2),(std::string*)0);

    BOOST_CHECK_EQUAL(sl::object_pointer_cast<char>(o3), (char*)0);
    BOOST_CHECK_EQUAL(sl::object_pointer_cast<short>(o3), (short*)0);
    BOOST_CHECK_EQUAL(sl::object_pointer_cast<int>(o3), (int*)0);
    BOOST_CHECK_EQUAL(sl::object_pointer_cast<long>(o3), (long*)0);
    BOOST_CHECK_EQUAL(sl::object_pointer_cast<float>(o3), (float*)0);
    BOOST_CHECK_EQUAL(sl::object_pointer_cast<double>(o3), (double*)0);
}
