#include <string>
#include <vector>
#include <sl/mangle/mangle.hpp>
#include <sl/mangle/demangle.hpp>


BOOST_AUTO_TEST_CASE(demangle_test)
{
}


BOOST_AUTO_TEST_CASE(mangle_primitive_test)
{
    BOOST_CHECK_EQUAL(sl::mangle("int"), typeid(int).name());
    BOOST_CHECK_EQUAL(sl::mangle("unsigned int"), typeid(unsigned int).name());
    BOOST_CHECK_EQUAL(sl::mangle("short"), typeid(short).name());
    BOOST_CHECK_EQUAL(sl::mangle("unsigned short"), typeid(unsigned short).name());
    BOOST_CHECK_EQUAL(sl::mangle("long"), typeid(long).name());
    BOOST_CHECK_EQUAL(sl::mangle("unsigned long"), typeid(unsigned long).name());
    BOOST_CHECK_EQUAL(sl::mangle("long long"), typeid(long long).name());
    BOOST_CHECK_EQUAL(sl::mangle("char"), typeid(char).name());
    BOOST_CHECK_EQUAL(sl::mangle("signed char"), typeid(signed char).name());
    BOOST_CHECK_EQUAL(sl::mangle("unsigned char"), typeid(unsigned char).name());
    BOOST_CHECK_EQUAL(sl::mangle("bool"), typeid(bool).name());
    BOOST_CHECK_EQUAL(sl::mangle("float"), typeid(float).name());
    BOOST_CHECK_EQUAL(sl::mangle("double"), typeid(double).name());

    BOOST_CHECK_EQUAL(sl::mangle("const int"), typeid(const int).name());
    BOOST_CHECK_EQUAL(sl::mangle("volatile int"), typeid(volatile int).name());
    BOOST_CHECK_EQUAL(sl::mangle("volatile const int"), typeid(volatile const int).name());
    BOOST_CHECK_EQUAL(sl::mangle("int *"), typeid(int*).name());
    BOOST_CHECK_EQUAL(sl::mangle("int &"), typeid(int&).name());
    BOOST_CHECK_EQUAL(sl::mangle("const int *"), typeid(const int*).name());
    BOOST_CHECK_EQUAL(sl::mangle("int const *"), typeid(int const*).name());
    BOOST_CHECK_EQUAL(sl::mangle("volatile int *"), typeid(volatile int*).name());
    BOOST_CHECK_EQUAL(sl::mangle("volatile const int *"), typeid(volatile const int*).name());
    BOOST_CHECK_EQUAL(sl::mangle("volatile int const *"), typeid(volatile int const*).name());
    BOOST_CHECK_EQUAL(sl::mangle("const volatile int *"), typeid(const volatile int*).name());
    BOOST_CHECK_EQUAL(sl::mangle("const volatile int const *"), typeid(const volatile int* const).name());
}

BOOST_AUTO_TEST_CASE(mangle_substitution_test)
{
    BOOST_CHECK_EQUAL(sl::mangle("std::vector<int, std::allocator<int> >"), typeid(std::vector<int>).name());
    BOOST_CHECK_EQUAL(sl::mangle("::std::vector<int, std::allocator<int> >"), typeid(::std::vector<int>).name());
    BOOST_CHECK_EQUAL(sl::mangle("std::allocator<char>"), typeid(std::allocator<char>).name());
    BOOST_CHECK_EQUAL(sl::mangle("::std::allocator<char>"), typeid(::std::allocator<char>).name());
    BOOST_CHECK_EQUAL(sl::mangle("std::basic_string<char, std::char_traits<char>, std::allocator<char> >"), typeid(std::basic_string<char, std::char_traits<char>, std::allocator<char> >).name());
    BOOST_CHECK_EQUAL(sl::mangle("std::basic_istream<char, std::char_traits<char> >"), typeid(std::basic_istream<char, std::char_traits<char> >).name());
    BOOST_CHECK_EQUAL(sl::mangle("std::basic_ostream<char,  std::char_traits<char> >"), typeid(std::basic_ostream<char,  std::char_traits<char> >).name());
    BOOST_CHECK_EQUAL(sl::mangle("std::basic_iostream<char, std::char_traits<char> >"), typeid(std::basic_iostream<char, std::char_traits<char> >).name());
}

BOOST_AUTO_TEST_CASE(mangle_function_test)
{
    BOOST_CHECK_EQUAL(sl::mangle("void boost::spirit::impl::match_attr_traits<std::basic_string<char, std::char_traits<char>, std::allocator<char> > >::copy<boost::spirit::match<boost::spirit::nil_t> >(boost::optional<std::basic_string<char, std::char_traits<char>, std::allocator<char> > >&, boost::spirit::match<boost::spirit::nil_t> const&)"),
"_ZN5boost6spirit4impl17match_attr_traitsISsE4copyINS0_5matchINS0_5nil_tEEEEEvRNS_8optionalISsEERKT_");
}
