#include <vector>
#include <sl/java/lang/Object.h>
#include <sl/java/lang/String.h>
#include <sl/java/util/Enumeration.h>
using namespace sl::java::lang;
using namespace sl::java::util;

BOOST_AUTO_TEST_CASE(enumeration_test)
{
	std::vector<Object> objs1;
	objs1.push_back(new String("abc"));
	objs1.push_back(new String("def"));
	objs1.push_back(new String("ghi"));

	Enumeration e1(objs1);

	int index = 0;
	while (e1.hasMoreElements()) {
		switch (index) {
		case 0 :
			BOOST_CHECK_EQUAL(sl::object_cast<String>(e1.nextElement()), "abc");
			break;
		case 1 :
			BOOST_CHECK_EQUAL(sl::object_cast<String>(e1.nextElement()), "def");
			break;
		case 2 :
			BOOST_CHECK_EQUAL(sl::object_cast<String>(e1.nextElement()), "ghi");
			break;
		}
		++index;
	}

	std::vector<Object> objs2 = e1;
	std::vector<Object>::iterator i = objs2.begin();
	for (; i != objs2.end(); i++) {
		switch (index) {
		case 0 :
			BOOST_CHECK_EQUAL(sl::object_cast<String>(*i), "abc");
			break;
		case 1 :
			BOOST_CHECK_EQUAL(sl::object_cast<String>(*i), "def");
			break;
		case 2 :
			BOOST_CHECK_EQUAL(sl::object_cast<String>(*i), "ghi");
			break;
		}
	}

	std::vector<Object> objs3;
	objs3.push_back(Object(new String("123")));
	objs3.push_back(Object(new String("456")));
	objs3.push_back(Object(new String("789")));
	Enumeration e2(objs3);

	/* Test Enumeration::operator=(...) */
	e1 = e2;
	index = 0;
	while (e1.hasMoreElements()) {
		switch (index) {
		case 0 :
			BOOST_CHECK_EQUAL(sl::object_cast<String>(e1.nextElement()), "123");
			break;
		case 1 :
			BOOST_CHECK_EQUAL(sl::object_cast<String>(e1.nextElement()), "456");
			break;
		case 2 :
			BOOST_CHECK_EQUAL(sl::object_cast<String>(e1.nextElement()), "789");
			break;
		}
		++index;
	}
}
