#include <iostream>

#include <sl/java/util/Date.h>
using namespace sl::java::util;

BOOST_AUTO_TEST_CASE(date_test)
{
	Date d1;
	Date d2(1216566680);            // Mon Jul 21 00:11:20 2008
	Date d3(1216566680 + 1000000);
	Date d4(d2);

	BOOST_CHECK_EQUAL(d1.toString(), "Thu Jan 01 09:00:00 1970");
	BOOST_CHECK_EQUAL(d1.getTime(), 0);
	BOOST_CHECK_EQUAL(d2.toString(), "Mon Jul 21 00:11:20 2008");
	BOOST_CHECK_EQUAL(d2.getTime(), 1216566680);
	BOOST_CHECK_EQUAL(d3.getTime(), 1217566680);
	BOOST_CHECK_EQUAL(d4.toString(), "Mon Jul 21 00:11:20 2008");
	BOOST_CHECK_EQUAL(d4.getTime(), 1216566680);

	// Date::after
	BOOST_CHECK_EQUAL(d1.after(d2), true);
	BOOST_CHECK_EQUAL(d2.after(d1), false);
	BOOST_CHECK_EQUAL(d2.after(d3), true);
	BOOST_CHECK_EQUAL(d3.after(d2), false);
	BOOST_CHECK_EQUAL(d4.after(d3), true);

	// Date::before
	BOOST_CHECK_EQUAL(d1.before(d2), false);
	BOOST_CHECK_EQUAL(d2.before(d1), true);
	BOOST_CHECK_EQUAL(d2.before(d3), false);
	BOOST_CHECK_EQUAL(d3.before(d2), true);
	BOOST_CHECK_EQUAL(d4.before(d3), false);

	// Date::compareTo
	BOOST_CHECK_EQUAL(d2.compareTo(d2), 0);
	BOOST_CHECK_EQUAL(d2.compareTo(d3), -1);
	BOOST_CHECK_EQUAL(d3.compareTo(d2), 1);
	BOOST_CHECK_EQUAL(d2.compareTo(d4), 0);

	// Date::equals
	BOOST_CHECK_EQUAL(d2.equals(d2), true);
	BOOST_CHECK_EQUAL(d2.equals(d3), false);
	BOOST_CHECK_EQUAL(d3.equals(d2), false);
	BOOST_CHECK_EQUAL(d2.equals(d4), true);

}
