#include <sl/java/lang/String.h>
using namespace sl::java::lang;


BOOST_AUTO_TEST_CASE(String_operator_test)
{
	String s1("abc");
	s1 += "def";
	BOOST_CHECK_EQUAL(s1, "abcdef");

	String s2("123");
	s1 = s2 + s1;
	BOOST_CHECK_EQUAL(s1, "123abcdef");
	BOOST_CHECK_EQUAL(s2, "123");

	std::string ss("ABC");
	s1 = ss;
	BOOST_CHECK_EQUAL(s1, "ABC");

	s1 = s2 + ss + s1 + "abc";
	BOOST_CHECK_EQUAL(s1, "123ABCABCabc");

	ss = s1;
	BOOST_CHECK_EQUAL(ss, "123ABCABCabc");

	BOOST_CHECK_EQUAL(ss, s1);
	BOOST_CHECK_EQUAL(s1, ss);
}


BOOST_AUTO_TEST_CASE(String_test)
{
	String s1("abc");
	Object o1(s1);
	BOOST_CHECK_EQUAL(sl::object_cast<String>(o1), "abc");

	Object o2(new String("abc"));
	BOOST_CHECK_EQUAL(sl::object_cast<String>(o2), "abc");
}


BOOST_AUTO_TEST_CASE(String_compareTo_test)
{
	String s1("abcdefghijklmn");
	BOOST_CHECK_EQUAL(s1.compareTo("abcdefghijklmn"), 0);

	String s2("abcdefghijklmn");
	BOOST_CHECK_EQUAL(s1.compareTo(s2), 0);

	Object o1(String("abcdefghijklmn"));
	BOOST_CHECK_EQUAL(s1.compareTo(o1), 0);
}


BOOST_AUTO_TEST_CASE(String_indexOf_test)
{
	String s1("abcdefghijklmn");
	BOOST_CHECK_EQUAL(s1.indexOf("abc"), 0);
	BOOST_CHECK_EQUAL(s1.indexOf("def"), 3);
}


BOOST_AUTO_TEST_CASE(String_toUpperCase_test)
{
	String s1("abcdefghijklmn");
	String s2("ABCDEFGHIJKLMN");
	BOOST_CHECK_EQUAL(s1.toUpperCase().compareTo(s2), 0);
	BOOST_CHECK_EQUAL(s1.toUpperCase(), s2);
}


BOOST_AUTO_TEST_CASE(String_replaceFirst_test)
{
	String s1("abc");
	std::string regex, replacement;
	BOOST_CHECK_THROW(s1.replaceFirst(regex, replacement), std::runtime_error);
}


BOOST_AUTO_TEST_CASE(String_replaceAll_test)
{
	String s1("abc");
	std::string regex, replacement;
	BOOST_CHECK_THROW(s1.replaceAll(regex, replacement), std::runtime_error);
}


BOOST_AUTO_TEST_CASE(String_valueOf_test)
{
	BOOST_CHECK_EQUAL(String::valueOf(1), "1");
	BOOST_CHECK_EQUAL(String::valueOf(0.1), "0.1");
	BOOST_CHECK_EQUAL("1", String::valueOf(1));

#if defined(HAVE_CXXABI_H)
	BOOST_CHECK_EQUAL(String::valueOf(Object(1)), "int");
#else
	BOOST_CHECK_EQUAL(String::valueOf(Object(1)), "i");
#endif
}
