#include <sl/java/lang/ClassLoader.h>

#include "modules/target.cpp"

class testClassLoader : public sl::java::lang::ClassLoader {
public :
	sl::java::lang::Class findSystemClass(const std::string& s)
	{
		return sl::java::lang::ClassLoader::findSystemClass(s);
	}

	void unloadClass(const std::string& s)
	{
		return sl::java::lang::ClassLoader::unloadClass(s);
	}
};

BOOST_AUTO_TEST_CASE(ClassLoader_test)
{
	testClassLoader loader;
	sl::java::lang::Class c = loader.findSystemClass("modules.target");

	boost::shared_ptr<modules::target> p = c.newInstance<modules::target>();
	BOOST_CHECK_EQUAL(p->name(), "modules::target");
}
