#include <string>
#include <sl/object.hpp>

namespace {
    class Sample {
    public :
        void name(const std::string& name) { _name = name; }
        std::string name() const { return _name; }

    private :
        std::string _name;
    };
}

namespace space1 {

    class Sample {
    public :
        void name(const std::string& name) { _name = name; }
        std::string name() const { return _name; }

    private :
        std::string _name;
    };

} // namespace space1

namespace space1 {
namespace space2 {

    class Sample {
    public :
        void name(const std::string& name) { _name = name; }
        std::string name() const { return _name; }

    private :
        std::string _name;
    };

} // namespace spece2
} // namespace space1


BOOST_AUTO_TEST_CASE(class_test)
{
    Sample                  si1;
    space1::Sample          si2;
    space1::space2::Sample  si3;
    si1.name("si1");
    si2.name("si2");
    si3.name("si3");

    Sample*                 sp1 = new Sample();
    space1::Sample*         sp2 = new space1::Sample();
    space1::space2::Sample* sp3 = new space1::space2::Sample();
    sp1->name("sp1");
    sp2->name("sp2");
    sp3->name("sp3");

    sl::object o1(si1);
    sl::object o2(si2);
    sl::object o3(si3);
    sl::object o4(sp1);
    sl::object o5(sp2);
    sl::object o6(sp3);

    Sample s1 = sl::object_cast<Sample>(o1);
    BOOST_CHECK_EQUAL(s1.name(), "si1");
    space1::Sample s2 = sl::object_cast<space1::Sample>(o2);
    BOOST_CHECK_EQUAL(s2.name(), "si2");
    space1::space2::Sample s3 = sl::object_cast<space1::space2::Sample>(o3);
    BOOST_CHECK_EQUAL(s3.name(), "si3");

    Sample& r1 = sl::object_cast<Sample>(o1);
    BOOST_CHECK_EQUAL(r1.name(), "si1");
    space1::Sample& r2 = sl::object_cast<space1::Sample>(o2);
    BOOST_CHECK_EQUAL(r2.name(), "si2");
    space1::space2::Sample& r3 = sl::object_cast<space1::space2::Sample>(o3);
    BOOST_CHECK_EQUAL(r3.name(), "si3");

    Sample ss1 = sl::object_cast<Sample>(o4);
    BOOST_CHECK_EQUAL(ss1.name(), "sp1");
    space1::Sample ss2 = sl::object_cast<space1::Sample>(o5);
    BOOST_CHECK_EQUAL(ss2.name(), "sp2");
    space1::space2::Sample ss3 = sl::object_cast<space1::space2::Sample>(o6);
    BOOST_CHECK_EQUAL(ss3.name(), "sp3");

    Sample& rr1 = sl::object_cast<Sample>(o4);
    BOOST_CHECK_EQUAL(rr1.name(), "sp1");
    space1::Sample& rr2 = sl::object_cast<space1::Sample>(o5);
    BOOST_CHECK_EQUAL(rr2.name(), "sp2");
    space1::space2::Sample& rr3 = sl::object_cast<space1::space2::Sample>(o6);
    BOOST_CHECK_EQUAL(rr3.name(), "sp3");
}
