/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_XML_TAG_H
#define SL_XML_TAG_H

#include <map>
#include <string>
#include <vector>

#include <sl/xml/xml_parser_error.h>

namespace sl {
namespace xml {

class xml_parser;
class xml_tag;

typedef std::vector<xml_tag*> tag_list_ptr;
typedef std::vector<xml_tag> tag_list_t;
typedef std::map<std::string, std::string> string_map_t;

/** ñΥݻ륯饹Ǥ. */
class xml_tag {
public :
    ~xml_tag();

    bool operator!();

    /**
     * Ȥ۲ˤ륿ΥꥹȤ֤ޤ.
     */
    tag_list_t get(const std::string& path="") const
        throw(xml_parser_error);

    /**
     * Ȥ۲ˤ륿ΥꥹȤ name ˥ޥå
     * ǤΤߤ֤ޤ.
     * @param    name    std::string ̾.
     * @return    .
     * @throw    xml_parser_error    륿ʣ¸ߤ.
     */
    xml_tag child(const std::string& name) const
        throw(xml_parser_error);

    /**
     * Ȥ۲ˤ륿ΥꥹȤ e ɲäޤ.
     */
    void child_tag(xml_tag *e);

    /**
     * ° map ֥Ȥ֤ޤ.
     * @return    map ֥.
     */
    string_map_t attributes() const;

    /**
     * ° map ֥Ȥ name 򥭡Ȥƻĥ֥Ȥ
     * ֤ͤޤ.
     * @return    std::string ʸ.
     */
    std::string attr(const std::string& name) const;

    /**
     * ° map ֥Ȥ̾ͤ pair ֥Ȥꤷޤ.
     * @param    value    string_map_t::value_type.
     */
    void attributes(string_map_t::value_type value);

    /**
     * ֤̾ޤ.
     * @return    std::string .
     */
    std::string name() const;

    /**
     * DATA֤ޤ.
     * @return    std::string .
     */
    std::string value() const;

private :
    std::string _name;
    std::string _value;
    string_map_t _attributes;

    xml_tag* _parent;
    xml_tag* _current;
    tag_list_ptr _childlen_ptr;
    tag_list_t _childlen;

    friend class xml_parser;
    friend class xml_info;
};


} // namespace xml
} // namespace sl

#endif // SL_XML_TAG_H
