/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: xml_tag.cpp,v 1.3 2007/03/08 17:02:31 cvsuser Exp $
 */

#include <iostream>

#include <sl/xml/xml_tag.h>
using namespace sl::xml;


xml_tag::~xml_tag()
{
}

//
// Operators.
//

bool xml_tag::operator!()
{
	return _name.empty();
}


tag_list_t xml_tag::get(const std::string &path) const
	throw(xml_parser_error)
{
	tag_list_t list;
	std::string tag_path = path;

	if (!tag_path.empty()) {
		std::string::size_type pos;
		bool last = (pos = tag_path.find('.')) == std::string::npos?true:false;

		std::string key = tag_path.substr(0, pos);
		tag_path.erase(0, pos + (last ? 0 : 1));

		tag_list_ptr::const_iterator i = _childlen_ptr.begin();
		for (; i != _childlen_ptr.end(); i ++) {
			if ((*i)->name() == key)
				list.push_back(**i);
		}

		if (list.size() == 0)
			return list;

		if (!last) {
			if (list.size() == 1)
				list = list.at(0).get(tag_path);
			else
				throw xml_parser_error("Target not one");
		}
	} else {
		tag_list_ptr::const_iterator i = _childlen_ptr.begin();
		for (; i != _childlen_ptr.end(); i ++)
			list.push_back(**i);
	}

	return list;
}


xml_tag xml_tag::child(const std::string &name) const
	throw(xml_parser_error)
{
	if (name.find(".") != std::string::npos)
		throw xml_parser_error(std::string("xml_parser_error, "
										"Target not child. [") + name + "]");

	tag_list_t list = get(name);
	if (list.size() == 0)
		throw xml_parser_error(std::string("xml_parser_error, "
										"Target not found. [") + name + "]");
	if (list.size() > 1)
		throw xml_parser_error(std::string("xml_parser_error, "
									    "Target too many found [") + name + "]");
	return list.at(0);
}


void xml_tag::child_tag(xml_tag *e)
{
	_childlen_ptr.push_back(e);
}


string_map_t xml_tag::attributes() const
{
	return _attributes;
}


std::string xml_tag::attr(const std::string &name) const
{
	string_map_t::const_iterator i = _attributes.find(name);
	return i != _attributes.end() ? i->second : "";
}


void xml_tag::attributes(string_map_t::value_type value)
{
	_attributes.insert(value);
}


std::string xml_tag::name() const
{
	return _name;
}


std::string xml_tag::value() const
{
	return _value;
}

