/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_XML_PARSER_H
#define SL_XML_PARSER_H

#include <expat.h>        // 3 party library for XML parser.
#include <string>

#include <sl/xml/xml_tag.h>
#include <sl/xml/xml_parser_error.h>

namespace sl {
namespace xml {

class xml_parser {
public :
    /** Constructor. */
    xml_parser();

    /**
     * Constructor. xml_parser::read() ¹Ԥޤ.
     *
     * @param    file_path    ѥޤXMLե̾.
     * @throw    invalid_argument    ѥʾꤲޤ.
     * @throw    runtime_error        եɤ߹ߥ顼XMLե
     *                                ʸ˥顼ꤲޤ.
     * @see        xml_parser::read()
     */
    xml_parser(const std::string& file_path) throw(xml_parser_error);

    xml_parser(const std::string::iterator& first,
               const std::string::iterator& last) throw(xml_parser_error);

    /**
     * Destructor.
     * ɤ߹XML˴ޤ.
     */
    ~xml_parser();

    /**
     * եɤ߹߽Ԥޤ.
     * @param    file_path    ѥޤXMLե̾.
     * @throw    invalid_argument    ѥʾꤲޤ.
     * @throw    runtime_error        XMLեɤ߹ߥ顼
     *                                ʸ˰۾郎ꤲޤ.
     */
    void read(const std::string& file_path) throw(xml_parser_error);

    /**
     * ǻꤵ줿 xml_tag ֤ޤ.
     * @return    xml_tag֥.
     */
    xml_tag get();

private :

    /**
     * ֤ޤ.
     * @throw    runtime_error    ˼Ԥꤲޤ.
     */
    void init() throw(xml_parser_error);

    /**
     * ֤ޤ.
     */
    void destroy();

    /**
     * ɤ߹XML˴ޤ.
     * @param    e    xml_tag.
     */
    void clear(xml_tag& e);

    /**
     * XMLեɤ߹ߡ¸Ԥޤ.
     * @param    file    xmlեƤݻstd::string֥.
     * @throw    runtime_error    ѡ˼Ԥꤲޤ.
     */
    void parse(const std::string& file) throw(xml_parser_error);

    /**
     * XMLǤγϥɤ߹߻˼¹Ԥޤ.
     * @param    data    void * ˥㥹Ȥ줿 xml_parser 󥹥.
     * @param    name    ̾.
     * @param    attr    ˵Ҥ줿°Υꥹ.
     */
    static void start_tag(void* data, const char* name, const char** attr);
    
    /**
     * XMLǤνλɤ߹߻˼¹Ԥޤ.
     * @param    data    void * ˥㥹Ȥ줿 xml_parser 󥹥.
     * @param    name    ̾.
     */
    static void end_tag(void* data, const char* name);
    
    /**
     * XMLǤDATAǤɤ߹߻˼¹Ԥޤ.
     * @param    data    void * ˥㥹Ȥ줿 xml_parser 󥹥.
     * @param    s        ʸ.
     * @param    len        ʸĹ.
     */
    static void data_tag(void* data, const XML_Char* s, int len);
    
    static void com_tag(void* data, const XML_Char* s);

    XML_Parser _parser;

    std::string _file;
    xml_tag _root_tag;
    xml_tag* _current;
};


} // namespace xml
} // namespace sl

#endif // XML_XML_PARSER_H
