/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_XML_INFORMATION_H
#define SL_XML_INFORMATION_H

#include <iostream>
#include <map>
#include <string>

#include <sl/xml/xml_tag.h>

namespace sl {
namespace xml {

class xml_info {
public :

    static void dump(xml_tag &p)
    {
        disp_start(p, 0);
        loop(p, 0);
        disp_end(p, 0);
    }

private :

    static void loop(xml_tag &e, int depth)
    {
        tag_list_t el = e.get();
        tag_list_t::iterator i = el.begin();
        for (; i != el.end(); i++) {
            disp_start(*i, depth + 1);
            loop(*i, depth + 1);
            disp_end(*i, depth + 1);
        }
    }

    static void disp_start(xml_tag &e, int depth)
    {
        for (int d = 0; d < depth; d++)
            std::cout << "  ";

        std::cout << "<" << e._name << "";

           string_map_t::iterator i = e.attributes().begin();
        for (; i != e.attributes().end(); i++) {
            std::cout << " " << i->first << "=\"" << i->second << "\"";
        }

        if (e.value().empty() && e.get().size())
            std::cout << " />" << std::endl;
        else
            std::cout << ">"; //  << std::endl;

        std::cout << e.value();
    }

    static void disp_end(xml_tag &e, int depth)
    {
        if (e.value().empty() &&
            e.attributes().size() && !e.get().size())
            return;

        for (int d = 0; d < depth; d++)
            std::cout << "  ";

        std::cout << "</" << e._name << ">" << std::endl;
    }
};

} // namespace xml
} // namespace sl

#endif // SL_XML_INFORMATION_H
