/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: class_def_parser.h,v 1.1 2007/08/06 13:23:25 cvsuser Exp $
 */

#ifndef SL_XML_CLASS_PARSER_CLASS_DEF_PARSER_H
#define SL_XML_CLASS_PARSER_CLASS_DEF_PARSER_H

#include <string>

#include <sl/xml/class_parser/class_def_grammar.h>

namespace sl {
namespace xml {

/**
 * @class class_def_parser.
 *
 * class/namespace ޤե(ϥإåե)Ϥ
 * XMLեȤƽϤޤ.
 *
 */
class class_def_parser {
public :
    /** Constuctor. */
    class_def_parser()
    { }

    /**
     * ѡϴؿ.
     *  file ˼ եβϤ¹Ԥޤ.
     *
     * @param    file_path оݤΥեѥ+̾.
     * @return    Ϸ̤XMLե.
     */
    std::string start(const std::string& file)
    {
        std::string s;
        callback_functors f;
        class_def_grammar p(f);

        boost::spirit::parse_info<> info =
                    boost::spirit::parse(file.c_str(), p, space_p);
        if (!info.full) {
            std::cerr << "parsing failed" << std::endl;
            std::cerr << "line at:" << info.stop << std::endl;
            return "";
        }

        std::string xml = f.xml();
#ifdef DEBUG
        cout << xml << endl;
#endif
        return xml;
    }
};

} // namespace xml
} // namespace sl

#endif // SL_XML_CLASS_PARSER_CLASS_DEF_PARSER_H
