/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_TEXT_TEXT_H
#define SL_TEXT_TEXT_H

#include <iostream>
#include <iomanip>
#include <sstream>
#include <stdexcept>
#include <string>
#include <map>

namespace sl {
namespace text {

/**
 * pƤ16ʿ+ASCIIʸɽޤ.
 * @param   p        ХȥǡΥݥ.
 * @param   length    ХĹ.
 * @param   width    ϤԤ.
 * @param   os         std::ostream.
 */
inline void hex_dump(const unsigned char *p, int length,
                     int width=40, std::ostream &os=std::cout)
{
    os << "hex dump start. dump size of " << length << std::endl;

    int len;
    int offset = 0;

    do {
        len = (length - offset) > width ? width : length - offset;

        for (int i = offset; i < offset + len; i++) {
            unsigned char ch = p[i];
            os << std::setw(2) << std::setfill('0') << std::hex
               << static_cast<unsigned long>(ch);
        }
        os << "\n";

        for (int i = offset; i < offset + len; i++) {
            unsigned char ch = p[i];
            if (ch < 0x20 || ch >= 0x7f)
                os << "^@";
            else
                os << " " << ch;
        }
        os << "\n";
        offset += len;

    } while (offset < length);
    os << std::dec;
}

/**
 * pƤ16ʿ+ASCIIʸɽޤ.
 * @param   p        ХȥǡΥݥ.
 * @param   length    ХĹ.
 * @param   width    ϤԤ.
 * @param   os         std::ostream.
 */
inline void hex_dump(const char *p, int length,
                    int width=40, std::ostream &os=std::cout)
{
    hex_dump((unsigned char*)p, length, width, os);
}

/**
 * pƤ16ʿ+ASCIIʸɽޤ.
 * @param   s        std::string ǡ.
 * @param   width    ϤԤ.
 * @param   os         std::ostream.
 */
inline void hex_dump(const std::string& s,
                    int width=40, std::ostream &os=std::cout)
{
    hex_dump(s.data(), s.length(), width, os);
}

/**
 *  s Ƭˤ c ƺޤ.
 * @param    str    åʸ.
 * @param    ch    åʸ.
 */
inline std::string chop(const std::string &str, char ch)
{
    int count;
    int length = str.size();

    for (count = 0; str[count] == ch && count < length; count++)
        /* NOTHING */;

    return str.substr(count);
}

/**
 * ʸʸ̵뤷ӽԤʤޤ.
 * @param    left    åʸ.
 * @param    right    åʸ.
 * @param    size    ʸ.
 * @return    0:ʬ̵, 0 ʳ: ʬ.
 */
inline int nocase_compare(const std::string &left,
              const std::string &right,
              std::string::size_type size=std::string::npos)
{
    if (left.size() != right.size() &&
        left.size() <= size && right.size() <= size)
        return -1;

    int result;
    for (size_t i = 0; i < left.size() && i < right.size() && i<size; i++) {
        if ((result = toupper(left[i]) - toupper(right[i])) != 0)
            return result;
    }
    return 0;
}

/**
 *  number ʸѴޤ.
 * @param    number    åʸ.
 */
template <typename T> std::string to(T number)
{
    std::ostringstream o;
    o << number;
    return std::string(o.str());
}

inline std::multimap<std::string, std::string>
ite_split(const std::string &str, const char div, const char term)
{
    using namespace std;

    multimap<string, string>    ite_map;
    string                target(str);
    string::size_type    pos;

    string    n, v;
    for (; (pos = target.find(div)) != std::string::npos; ) {
        n = target.substr(0, pos);
        target.erase(0, pos + 1);

        pos = target.find(term);
        v = target.substr(0, pos);
        ite_map.insert(multimap<string, string>::value_type(n, v));

        if (pos == string::npos)
            break;
        else
            target.erase(0, pos + 1);
    }
    return ite_map;
}

inline std::string upper_case(const std::string &str)
{
    std::string s(str);
    for (size_t i = 0; i < s.length(); i++) {
        s[i] = toupper(str[i]);
    }
    return s;
}

}  // namespace text
}  // namespace sl

#endif // SL_TEXT_TEXT_H
