/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: random.h,v 1.5 2006/10/28 16:25:29 cvsuser Exp $
 */

#ifndef SL_TEXT_RANDOM_H
#define SL_TEXT_RANDOM_H

#include <algorithm>
#include <string>

namespace sl {
namespace text {
namespace detail {

static size_t length = 32;

static std::string magic = "z9hG4bk";

static std::string alphabet =
    "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

static std::string numeric =
    "123456789012345678901234567890123456789012345678901234567890";

inline int seed(int)
{
    static bool first = true;
    if (first) {
        srand(time(0));
        first = false;
    }
    return rand() % 64;
}

inline std::string shuffle(const std::string& s, size_t len)
{
    std::string temp(s);
    std::random_shuffle(temp.begin(), temp.end(), seed);
    return temp.substr(1, len < length ? len : length);
}

} // namespace detail

inline std::string rando_alpha(size_t len=32)
{
    std::string s = detail::alphabet + detail::alphabet;
    return detail::shuffle(s, len);
}

inline std::string rando_numeric(size_t len=32)
{
    std::string s = detail::numeric + detail::numeric;
    return detail::shuffle(s, len);
}

inline std::string rando_alnum(size_t len=32)
{
    std::string s = detail::alphabet + detail::numeric;
    return detail::shuffle(s, len);
}

inline std::string random(size_t len=32)
{
    std::string s = detail::alphabet + detail::numeric;
    return detail::shuffle(s, len);
}

inline std::string rando_branch(size_t len=32)
{
    size_t len1 = len;
    size_t len2 = len - detail::magic.length();

    std::string s = detail::alphabet + detail::numeric;
    std::string result = detail::shuffle(s, len);
    return detail::magic + result.substr(1, len1 < len2 ? len1 : len2);
}

} // namespac text
} // namespac sl

#endif // SL_TEXT_RANDOM_H
