/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_TEXT_BASE_64_H
#define SL_TEXT_BASE_64_H

#include <map>
#include <string>
#include <stdexcept>

namespace sl {
namespace text {

class base64 {
public :

    /**
     *  s  base64 󥳡ɤԤʤä֤ͤޤ.
     *
     * @param    s    󥳡оݤʸ.
     * @return    󥳡ɸʸ.
     */
    static std::string encode(const std::string& s)
    {
        std::string temp(s);
        std::string dest;

        for (;;) {
            /* Ƭ 3byte Ф */
            unsigned long bits;
            int read = first3byte(temp, bits);

            /*
             * 24bits Ƭ 6bits Ťɤ߹.
             * ɤ߹ Byte  3byte Ǥʤ
             * Ŭڤʰ֤ɤ߹ߤλ.
             */
            for (int i = 3; i >= 0 && read-- >= 0; i--) {
                int offset = (bits >> (i * 6)) & 0x3F;
                dest.append(1, instance()._code_map[offset]);
            }

            /* ɤ߹ʸ 3ХȰʲǤ '=' ղäƽλ */
            if (temp.length() <= 3) {
                for (size_t i = 3; i > temp.length(); i--)
                    dest.append(1, '=');
                break;
            }

            /* ³ϴɤ߹ 3ХȤ. */
            temp.erase(0, 3);
        }
        return dest;
    }

    /**
     *  s  base64 ǥɤԤʤä֤ͤޤ.
     * ̾ϥ󥳡ɤ줿ʸĹ4ܿȤʤϤʤΤ
     * ʸĹ⤷4ܿǤʤ std::runtime_error ꤲޤ.
     *
     * @param    s    ǥоݤʸ.
     * @return    ǥɸʸ.
     */
    static std::string decode(const std::string& s)
    {
        if (s.empty() || s.length() % 4)
            throw std::runtime_error("base64 exception: invalid argument:" + s);

        std::string temp(s);
        std::string dest;

        do {
            unsigned long bits = 0;

            /* 4ХȤФbits ˳Ǽ. */
            for (int i = 0; i < 4; i++) {
                bits <<= 6;
                bits |= char2bits(temp[i]);
            }

            dest.append(1, ((unsigned char*)&bits)[2]);
            if (((unsigned char*)&bits)[1] != 0x00)
                dest.append(1, ((unsigned char*)&bits)[1]);
            if (((unsigned char*)&bits)[0] != 0x00)
                dest.append(1, ((unsigned char*)&bits)[0]);

            temp.erase(0, 4);
        } while (temp.length() != 0);

        return dest;
    }

private :
    static base64& instance()
    {
        static base64 instance;
        return instance;
    }

    /** Constructor. */
    base64()
    {
        static std::string characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                                        "abcdefghijkjmnopqrstuvwxyz"
                                        "0123456789+/";

        std::string::const_iterator i = characters.begin();
        for (int code = 0; i != characters.end(); code++, i++)
            _code_map.insert(std::make_pair(code, *i));
    }

    /**
     *  s Ƭ3ХȤ bits ˳Ǽ.
     * ⤷ s  3ХȤʤǤäƤ⡢
     * bits Ŭڤ˥եȤ.
     *
     * @param    s        ʸ.
     * @param    bits    24ӥåȤγǼ.
     * @return        ɤ߹Хȿ.
     */
    static int first3byte(const std::string& s, unsigned long& bits)
    {
        bits = 0;
        size_t i;
        for (i = 0; i < s.length() && i < 3; i++) {
            bits <<= 8;
            bits |= (unsigned long)s[i];
        }
        bits <<= 8 * (3 - i);    /* ֤˥եȤƤ. */
        return i;
    }

    static unsigned long char2bits(char ch)
    {
        if (ch == '=')
            return 0x00;

        std::map<int, char>::iterator i = instance()._code_map.begin();
        for (; i != instance()._code_map.end(); i++) {
            if (i->second == ch)
                return (unsigned long)i->first;
        }
        return 0xFF;
    }

    std::map<int, char> _code_map;
};

} // namespace text
} // namespace sl

#endif // SL_TEXT_BASE_64_H
