/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: clock.h,v 1.3 2006/10/29 11:16:21 cvsuser Exp $
 */

#ifndef SL_SYS_CLOCK_H
#define SL_SYS_CLOCK_H

#include <sys/time.h>

namespace sl {
  namespace sys {

	class clock {
		double _time;

	public :
		static void start()
		{
			struct timeval tv;
			gettimeofday(&tv, NULL);
			instance()._time = tv.tv_sec + (double)tv.tv_usec*1e-6;
		}

		static double elapsed()
		{
			struct timeval tv;
			gettimeofday(&tv, NULL);
			double current = tv.tv_sec + (double)tv.tv_usec*1e-6;
			return current - instance()._time;
		}

	private :
		clock() { }

		static clock& instance()
		{
			static clock instance;
			return instance;
		}
	};

  } // namespace sys
} // namespace sl

#endif // SL_SYS_CLOCK_H
