/*-
 * Copyright (c) 2008 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_OBJECT_OBJECT_HPP
#define SL_OBJECT_OBJECT_HPP

#include <string>
#include <boost/shared_ptr.hpp>

#include <sl/mangle/demangle.hpp>
#include <sl/object/holder.hpp>

namespace sl {

class object;

template <typename ValueType>
inline ValueType& object_cast(object& o) throw(std::bad_cast);

template <typename ValueType>
inline ValueType object_cast(const object& o) throw(std::bad_cast);

/**
 * object 饹.
 *
 * Java ǸȤ java.lang.Object 魯뤿Υ饹Ǥ.
 *  object 饹ϥ桼Ф륤󥿡ե󶡤ᥤ
 * ͤݻ holder 饹 holder_base 饹Ǽ¹Ԥơ
 * 㥹Ȥˤͤμ holder_cast Ǽ¹Ԥޤ.
 */
class object {
public :
    /** ʤ󥹥ȥ饯. */
    object() : _object() { }

    /**
     * ꥳ󥹥ȥ饯.
     *
     * ͤȷݻ holder饹ǤΤǤǤ
     * holder饹.
     *  to_stringдؿѤ˷̾ݻƤ.
     *
     * @param ݻо Ǥդη.
     */
    template <typename ValueType>
    object(ValueType value)
        : _object(boost::shared_ptr<detail::holder_base>(
                new detail::holder<ValueType>(value)))
    {
    }

    /**
     * ǥȥ饯.
     *
     * ݻƤͤݥ󥿤ä delete ɬפǤ
     * ¹ԤƤʤɤνɬ.
     */
    ~object()
    {
    }

    /**
     * ԡ󥹥ȥ饯.
     *
     * ݻƤͤݥ󥿤ä delete ɬפǤ
     * ¹ԤƤʤɤνɬ.
     */
    object(const object& r)
    {
        _object = r._object;
    }

    /**
     * ݻͤη֤̾.
     *
     * JavaObjecttoString֤Τʤ...
     */
    std::string to_string() const
    {
        return _object ? demangle(_object->name()) : std::string();
    }

    /**
     *  JavaObjectˤäӴؿ.
     *
     * ޤӤ狼ʤ.
     */
    bool equals(const object& r) const
    {
        return _object == r._object;
    }

    /**
     * ꤵ줿ݻƤͤηӴؿ.
     *
     *  typeid(T).name() ݻ̾Ӥ
     * 㥹Ȥ뤫®٤ᤤΤ
     * ϥ㥹Ȥμ¹Է̤֤.
     *
     * 㥹Ȥ֤ͤȤ뤿;פʽΤ
     * äȤȼɬפ!!
     *
     * @return bool Ʊ.
     */
    template <typename T>
    bool instanceof()
    {
        try { object_cast<T>(*this); } catch (...) { return false; }
        return true;
    }

    /**
     * ꤵ줿ݻƤͤηӴؿ.
     *
     * const ̵ instanceof Ʊ
     * const դ object Υ㥹ȤͤȤͤΥԡ֤
     * const object ѤΤΤ¹ԤƤޤ
     * ®Ū礭㲼.
     * ʤΤ const դ object 򤳤δؿǹԤʤ.
     *
     * @return bool Ʊ.
     */
    template <typename T>
    bool instanceof() const
    {
        try { object_cast<T>(*this); } catch (...) { return false; }
        return true;
    }

    /**
     * object  null ȽѴؿ.
     * object ޤˤͤݻƤ true ֤ޤ.
     *
     * @return bool Ƚ.
     */
    operator bool() const
    {
        return _object;
    }

private :
    boost::shared_ptr<detail::holder_base> _object;

    template <typename T>
    friend T* object_pointer_cast(const object& o);
};

} // namespace sl

#endif  // SL_OBJECT_OBJECT_HPP
