/*-
 * Copyright (c) 2008 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_OBJECT_HOLDER_HPP
#define SL_OBJECT_HOLDER_HPP

#ifndef DEBUG
#include <iostream>
#endif
#include <stdexcept>
#include <string>
#include <boost/shared_ptr.hpp>
#include <boost/type_traits.hpp>
#include <boost/utility/enable_if.hpp>
#include <boost/version.hpp>

#include <sl/object/objectable.hpp>

namespace sl {
namespace detail {

/**
 * @interface
 *
 * ݻ holder 饹̵̾¸뤿Υ饹.
 *
 * ݻ륯饹̤ηˤʤäƤޤ
 * object Τ褦ʥ饹¸ǤʤΤ
 * ݻ륯饹δ쥯饹ȤƻѤ.
 */
class holder_base {
public :
    virtual ~holder_base() { }

    /**
     * ݻ饹 objectable ѾƤ뤫Ƚꤹ.
     *
     * @return bool Ƚ
     */
    virtual bool is_objectable() const=0;

    /**
     * ݻ饹 objectable Υݥ󥿤֤ޤ.
     *  objectable Υݥ󥿤ϼʷ
     * 㥹Ȥɬפޤ.
     *
     * @return objectable* ݻƤ륪֥ȤΥݥ.
     */
    virtual objectable* holder_base_pointer()=0;

    /**
     * ̾ݻƤβ۴ؿ.
     * object  holder ͳݻ
     * object::to_string дؿ¹Ԥ줿˻Ȥ.
     */
    virtual const std::string& name() const=0;

    /**
     * ¸Ȥȥݥ󥿤ȤƼ.
     * 㥹ȼ¹Ի objectable ƤƤġ
     * δؿ true ֤(ɥ쥹Ȥ¸줿)
     * objectable إ㥹Ȥ¹Ԥ.
     */
    virtual bool is_pointer() const=0;
};


/**
 * ꤵ줿 objectable Υݥ󥿷˥㥹Ȥޤ.
 *
 *  holder_base_pointer_cast  enable_if Ѥ
 * objectable Ƥ뷿ξϥ㥹ȷ̤֤
 * ۤʤ 0 ֤ޤ.
 *
 * ºݤΥ㥹Ƚ cast_from_pointer_or_reference ؿǹԤʤäƤޤ.
 *
 * @param value 㥹о.
 * @param enable_if<> objectable 饹Ƚꤹ.
 * @return objectable* 㥹ȷ.
 */
template <typename T>
inline objectable* holder_base_pointer_cast(T value, 
    typename boost::enable_if<
#if BOOST_VERSION >= 103300
        boost::is_base_of<objectable,
#else
        boost::is_base_and_derived<objectable,
#endif
                        typename boost::remove_pointer<T>::type
        >
    >::type* = 0)
{
    return cast_from_pointer_or_reference(value);
}

/**
 * objectable ѾƤʤФ륭㥹Ƚ.
 *
 * objectable ƤʤФ륭㥹Ȥ⥨顼ˤʤʤ褦
 * Ѱդ줿ü첽ƥץ졼ȴؿ.
 *
 * @param value 㥹о.
 * @param disable_if<> objectable 饹Ƚ.
 * @return objectable* 㥹ȷ.
 */
template <typename T>
inline objectable* holder_base_pointer_cast(T /* value */,
    typename boost::disable_if<
#if BOOST_VERSION >= 103300
        boost::is_base_of<objectable,
#else
        boost::is_base_and_derived<objectable,
#endif
                        typename boost::remove_pointer<T>::type
        >
    >::type* = 0)
{
    return 0;
}

/**
 * ݥ󥿷ͤ objectable إ㥹Ȥؿ.
 *
 * objectable Υݥ󥿷ؤΥ㥹Ȼ˥㥹оݤηˤ
 * ü첽¸뤿νǤ.
 */
template <typename T>
inline objectable* cast_from_pointer_or_reference(T value,
    typename boost::enable_if<boost::is_pointer<T> >::type* = 0)
{
    return value;
}

/**
 * ݥ󥿰ʳͤ objectable إ㥹Ȥؿ.
 *
 * objectable Υݥ󥿷ؤΥ㥹Ȼ˥㥹оݤηˤ
 * ü첽¸뤿νǤ.
 */
template <typename T>
inline objectable* cast_from_pointer_or_reference(T& value,
    typename boost::disable_if<boost::is_pointer<T> >::type* = 0)
{
    return &value;
}


/**
 * ȼºݤͤݻ륯饹.
 *
 * ͡ݥ󥿤鷺ݻǤ褦˴ĥäݻѥ饹Ǥ.
 * object 饹ͤ¸ݤ˻Ѥ륯饹ǡ
 * holder_base ѾƤ뤿 object ¦Ǥ
 * holder_base Υݥ󥿤Ȥݻޤ.
 *
 * ޤobjectable ε¸뤿ͤݻ¹Ի
 * ݻͤη objectable ѾƤ뤫ȽԤʤޤ.
 *
 * 󥹥ȥ饯Ϥ줿ͤηˤäͤκ⼫ưǹԤޤ.
 * ݥ󥿰ʳηä˺Ϥʤ.
 * ݥ󥿷ξ boost::shared_ptr ݻƤƼȤ
 * äˤĤǤ˺ޤ.
 *
 * const 줿ݥ󥿷Ϻޤ.
 * ʸ 'const char*' Ϥ뤿Ǥ.
 */
template <typename ValueType>
class holder : public holder_base {
    typedef typename boost::remove_pointer<ValueType>::type ref_type;

public :
    /**
     * оݤݻƤʤ holder 󥹥󥹤ޤ.
     */
    holder()
        : _value(), _name(), _is_objectable(false)
    { }

    /**
     *  ValueType ΥԡоݤȤݻ holder
     * 󥹥󥹤ޤ.
     *
     * @param i ValueType 󥹥󥹤Υԡ.
     */
    holder(ValueType i)
        : _value(i),
          _name(typeid(i).name()),
#if BOOST_VERSION >= 103300
          _is_objectable(boost::is_base_of<objectable,
#else
          _is_objectable(boost::is_base_and_derived<objectable,
#endif
                typename boost::remove_pointer<ValueType>::type>::value),
          _is_pointer(boost::is_pointer<ValueType>::value)
    {
        set_auto_delete(i);
    }

    ~holder()
    { }

    /**
     * holder ݻ ValueType ؤλȤ֤ޤ.
     *
     * @return    ValueType ؤλ.
     */
    operator ValueType&()
    {
        return _value;
    }

    /**
     * ݻƤͤ objectable Υݥ󥿷Ȥ֤ޤ.
     * Ԥ 0 ֤ޤ.
     * is_objectable  true ֤ 0 ֤ϤʤϤ...
     *
     * @return ݻƤͤ objectable إ㥹Ȥ.
     */
    virtual objectable* holder_base_pointer()
    {
        return holder_base_pointer_cast(_value);
    }

    virtual const std::string& name() const
    {
        return _name;
    }

    /**
     * objectable ѾݻƤ뤫ȽԤʤޤ.
     *
     * @return bool Ƚ.
     */
    virtual bool is_objectable() const
    {
        return _is_objectable;
    }

    /**
     * ݻƤͤݥ󥿤Ǥ뤫Ƚꤷޤ.
     *
     * @return bool Ƚ.
     */
    virtual bool is_pointer() const
    {
        return _is_pointer;
    }

private :

    template <typename T>
    void set_auto_delete(T value,
        typename boost::enable_if<boost::is_pointer<T> >::type* = 0)
    {
        /* ʤ pointer Ϥʤ const ǧʤ */
        if (!boost::is_const<
                typename boost::remove_pointer<T>::type>::value) {
            _pointer = boost::shared_ptr<ref_type>(value);
        }
    }

    template <typename T>
    void set_auto_delete(T /* value */,
        typename boost::disable_if<boost::is_pointer<T> >::type* = 0)
    {
    }

    ValueType _value;
    std::string _name;
    boost::shared_ptr<ref_type> _pointer;
    bool _is_objectable;
    bool _is_pointer;
};


/**
 * 㥹ѥ饹.
 *
 * object ݻƤ֤ФȤ߹߷桼ʻ
 * 㥹Ȥ¹Ԥޤ.
 * 㥹ȤȤƻꤵ줿(CastType)ݥ󥿰ʳξ
 * ݻƤͤݥ󥿤ǤϤʤȽǤ,
 *   1.̾ηȤƥ㥹Ȥ
 *   2.Ԥݥ󥿷Ȥƥ㥹Ȥߤ
 * Ȥǥ㥹Ȥޤ.
 * CastTypeݥ󥿷ξϾ嵭Ȥϵդ
 *   1.ݥ󥿷Ȥƥ㥹Ȥߤ
 * Ԥʤޤ.
 *
 */
template <typename CastType, class = void>
class holder_cast {
public :
    /**
     * Constructor.
     * 󥹥ȥ饯Ǥäȥ㥹Ȥƥ㥹ȸη̤
     * Ф¸Ƥ.
     *
     * @param obj  㥹о.
     */
    holder_cast(detail::holder_base* obj)
    {
        _value = get_pointer_of_cast_type<CastType>(obj);
    }

    /**
     * 󥹥ȥ饯ǤΥ㥹ȷ̤֤.
     *
     * @return CastType  㥹ȷ̤Υݥ.
     */
    operator CastType*() const
    {
        return _value;
    }

private :

    /**
     * 㥹Ȥ˻ꤵ줿ݥ󥿰ʳξѤΥ㥹Ƚ.
     * ɤͤʷꤵƤ⤽ηΥݥ󥿤֤.
     *
     * @param obj 㥹о.
     * @param disable_if<>::type ݥ󥿰ʳȽtemplate.
     * @return 㥹Ȥ뷿˥ݥ󥿤ղä.
     */
    template <typename T>
    typename boost::add_pointer<T>::type
    get_pointer_of_cast_type(detail::holder_base* obj,
        typename boost::disable_if<boost::is_pointer<T> >::type* = 0)
    {
        /**
         * ١֥Ȥݥ󥿰ʳꤷƥ㥹ȼ¹
         */
        detail::holder<T>* ret1 =
                    dynamic_cast<detail::holder<T>*>(obj);
        if (ret1)
            return &(ret1->operator T&());

        /**
         * ١֥Ȥݥ󥿤ꤷƥ㥹ȼ¹
         */
        detail::holder<T*>* ret2 =
                    dynamic_cast<detail::holder<T*>*>(obj);
        if (ret2)
            return ret2->operator T*&();
        return 0;
    }

    /**
     * 㥹Ȥ˻ꤵ줿ݥ󥿤ξѤΥ㥹Ƚ.
     * ɤͤʷꤵƤ⤽ηΥݥ󥿤֤.
     *
     * @param obj 㥹о.
     * @param enable_if<>::type ݥ󥿤Ƚtemplate.
     * @return 㥹Ȥ뷿˥ݥ󥿤ղä.
     */
    template <typename T>
    typename boost::add_pointer<T>::type
    get_pointer_of_cast_type(detail::holder_base* obj,
    typename boost::enable_if<boost::is_pointer<T> >::type* = 0)
    {
        /**
         * ١֥Ȥݥ󥿤ꤷƥ㥹ȼ¹
         */
        detail::holder<T>* ret1 =
                    dynamic_cast<detail::holder<T>*>(obj);
        if (ret1)
            return &ret1->operator T&();
        return 0;
    }

    CastType* _value;
};


/**
 * 㥹ѥ饹Υ饹Ѥü첽ƥץ졼ȥ饹.
 *
 * ü첽Ƥʤ holder_cast 饹ȤۤƱ
 * 饹ФƼ¸ޤ.
 * 㥹ȤȤƻꤵ줿(CastType)ݥ󥿰ʳξ
 * ݻƤͤݥ󥿤ǤϤʤȽǤ,
 *   1.̾ηȤƥ㥹Ȥ
 *   2.Ԥݥ󥿷Ȥƥ㥹Ȥߤ
 */
template <typename CastType>
class holder_cast
    <
     CastType,
     typename boost::enable_if<boost::is_class<CastType> >::type
    >
{
public :
    /**
     * Constructor.
     * ü첽Ƥʤ holder_cast 饹Ʊͤ
     * 󥹥ȥ饯ǥ㥹ȤԤʤФ¸Ƥ.
     *
     * @param obj  㥹о.
     */
    holder_cast(detail::holder_base* obj)
    {
        /**
         * 㥹оݤΥ饹 objectable ѾƤǤ
         * ݥ󥿤Ȥ¸줿
         * objectableΥݥ󥿤ټФCastTypeѴ
         */
        if (obj->is_pointer() && obj->is_objectable()) {
            _value = dynamic_cast<CastType*>(obj->holder_base_pointer());
            if (_value)
                return;
        }

        /**
         * ١֥Ȥݥ󥿰ʳꤷƥ㥹ȼ¹
         */
        detail::holder<CastType>* ret1 =
            dynamic_cast<detail::holder<CastType>*>(obj);
        if (ret1) {
            _value = &(ret1->operator CastType&());
            return ;
        }

        /**
         * ١֥Ȥݥ󥿤ꤷƥ㥹ȼ¹
         */
        detail::holder<CastType*>* ret2 =
                dynamic_cast<detail::holder<CastType*>*>(obj);
        if (ret2) {
            _value = ret2->operator CastType*&();
            return ;
        }
        _value = 0;
    }

    /**
     * 󥹥ȥ饯ǤΥ㥹ȷ̤֤.
     *
     * @return CastType  㥹ȷ̤Υݥ.
     */
    operator CastType*() const
    {
        return _value;
    }

private :
    CastType* _value;
};

} // namespace detail
} // namespace sl

#endif  // SL_OBJECT_HOLDER_HPP
