/*-
 * Copyright (c) 2008 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_OBJECT_CAST_HPP
#define SL_OBJECT_CAST_HPP

#include <stdexcept>
#include <boost/type_traits.hpp>
#include <boost/utility/enable_if.hpp>

#include <sl/object/object.hpp>
#include <sl/mangle/demangle.hpp>

namespace sl {

/**
 * object_cast<> Ԥ㳰饹Ǥ.
 * std::bad_cast ѾƤꡢwhat дؿˤͳǽǤ.
 */
template <typename T>
class bad_object_cast : public std::bad_cast {
public :
    /**
     * 󥹥ȥ饯.
     * ʥ㥹ȤȹԤä֥Ȥޤ.
     *
     * @param sl::object 㥹оݤΥ֥.
     */
    bad_object_cast(const object& o)
    {
        _msg = std::string("exception: Invalid cast `") +
                o.to_string() + "' to `" +
                demangle(typeid(T).name()) + "'.";
    }

    ~bad_object_cast() throw() { }

    /**
     * 㳰줿֤ޤ.
     *
     * @return std::string ɽʸ.
     */
    const char* what() const throw() { return _msg.c_str(); }

private :
    std::string _msg;
};


/**
 * object ݻƤͤΥ㥹Ƚ.
 *
 * δؿ object 饹Ф friend ꤵƤ
 * object ݻͤ򥭥㥹ȻꤷؤΥݥ󥿤֤ޤ.
 * 㥹Ȥ˼Ԥ 0 ֤ޤ.
 *
 * @param 㥹оݤ object.
 * @return 㥹ȤƤ줿ؤΥݥ.
 */
template <typename CastType>
inline CastType* object_pointer_cast(const object& o)
{
    typedef typename boost::remove_reference<CastType>::type T;

    return o ? detail::holder_cast<T>(o._object.get()) : 0;
}

/**
 * object ǤդηؤΥ㥹Ƚ.
 *
 * object ݻͤꤷ˥㥹Ȥޤ.
 * ͤϥ㥹ȻꤷλȤˤʤޤ.
 * 
 * @param 㥹оݤ object.
 * @return 㥹ȤƤ줿ؤλ.
 * @throw std::bad_cast 㥹ȼԻꤲ.
 */
template <typename ValueType>
inline ValueType& object_cast(object& o) throw(std::bad_cast)
{
    typedef typename boost::remove_reference<ValueType>::type T;

    T* p = object_pointer_cast<T>(o);
    if (p)
        return *p;
    throw bad_object_cast<ValueType>(o);
}

/**
 * const 줿 object ǤդηؤΥ㥹Ƚ.
 *
 * object ݻͤꤷ˥㥹Ȥޤ.
 * ͤϥ㥹ȻꤷΥԡˤʤޤ.
 * 
 * @param 㥹оݤ object.
 * @return 㥹ȤƤ줿Υԡ.
 * @throw std::bad_cast 㥹ȼԻꤲ.
 */
template <typename ValueType>
inline ValueType object_cast(const object& o) throw(std::bad_cast)
{
    typedef typename boost::remove_reference<ValueType>::type T;

    T* p = object_pointer_cast<T>(o);
    if (p)
        return *p;
    throw bad_object_cast<ValueType>(o);
}

} // namespace sl

#include <sl/object/string_relates_cast.hpp>

#endif  // SL_OBJECT_CAST_HPP
