/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: writer.h,v 1.1 2006/10/28 16:08:25 cvsuser Exp $
 */

#ifndef SL_NET_HTTP_WRITER_H
#define SL_NET_HTTP_WRITER_H

#include <time.h>

#include <sl/net/http/message.h>

namespace sl {
  namespace net {
    namespace http {

	class writer {
	public :
		writer();

		virtual ~writer() { }

		/**
		 *  msg ǥץ fd ФƽϤޤ.
		 * ؿƽл˽񤭹Ԥ֤Ǥϡ
		 *  timeout Ԥޤ.
		 * ºݤ msg  fd 񤭹߽ _write ؿѤޤ.
		 *
		 * @param	fd		åȥǥץ.
		 * @param	msg		HTTP-Message.
		 * @param	timeout	񤭹ԤǤΥॢȻ.
		 *
		 * @note	timeout	֤ϸ߼Ƥޤ.
		 */
		int write(int fd, message& msg, time_t timeout);

		/**
		 *  msg إåФǥץ fd ФƽϤޤ.
		 * ؿƽл˽񤭹Ԥ֤Ǥϡ
		 *  timeout Ԥޤ.
		 * ºݤ msg  fd 񤭹߽ _write ؿѤޤ.
		 *
		 * @param	fd		åȥǥץ.
		 * @param	msg		HTTP-Message.
		 * @param	timeout	񤭹ԤǤΥॢȻ.
		 *
		 * @note	timeout	֤ϸ߼Ƥޤ.
		 */
		int write_headers(int fd, message& msg, time_t timeout);

		/**
		 *  msg åܥǥФǥץ fd 
		 * ФƽϤޤ.
		 * ؿƽл˽񤭹Ԥ֤Ǥϡ
		 *  timeout Ԥޤ.
		 * ºݤ msg  fd 񤭹߽ _write ؿѤޤ.
		 *
		 * @param	fd		åȥǥץ.
		 * @param	msg		HTTP-Message.
		 * @param	timeout	񤭹ԤǤΥॢȻ.
		 *
		 * @note	timeout	֤ϸ߼Ƥޤ.
		 */
		int write_body(int fd, message& msg, time_t timeout);

		/**
		 * 񤭹߽ǽ֤ˤޤ.
		 * δؿ¹˾嵭 write_* ؿ¹Ԥ
		 * ٤ƥ顼Ȥʤޤ.
		 */
		void start();

		/**
		 * 񤭹߽Բľ֤ˤޤ.
		 * δؿ¹Ը˾嵭 write_* ؿ¹Ԥ
		 * ٤ƥ顼Ȥʤޤ.
		 * ξ֤ write Ʊ֤Ȥʤꡢ
		 * start ؿμ¹Ԥˤꡢ񤭹߽βǽ֤Ȥʤޤ.
		 */
		void stop();

		/**
		 * ºݤ˥ǥץ fd Ф񤭹߽ԤʤؿǤ.
		 * ɬפХС饤ɤ뤳ȤǽǤ.
		 *
		 * @param	fd		åΥǥץ.
		 * @param	buffer	ϥХȥǡ.
		 * @param	size	ϥХĹ.
		 * @return	ºݤν񤭹ߥХȿ.
		 */
		virtual int _write(int fd, const char *buffer, size_t size);

	private :
		volatile bool _start;
	};

    } // namespace http
  } // namespace net
} // namespace sl

#endif // SL_NET_HTTP_WRITER_H
