/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: writer.cpp,v 1.1 2006/10/28 16:08:25 cvsuser Exp $
 */

#include <unistd.h>

#include <sl/net/http/http_error.h>
#include <sl/net/http/writer.h>
#include <sl/net/http/message.h>
using namespace sl::net::http;

writer::writer()
{
	start();
}

int writer::write(int fd, message& msg, time_t /* timeout */)
{
	if (_start == false)
		return 0;

	std::string text = msg.text();
	return _write(fd, text.c_str(), text.length());
}

int writer::write_headers(int fd, message& msg, time_t /* timeout */)
{
	if (_start == false)
		return 0;

	std::string text = msg.text_header();
	return _write(fd, text.c_str(), text.length());
}

int writer::write_body(int fd, message& msg, time_t /* timeout */)
{
	if (_start == false)
		return 0;

	std::string text = msg.text_body();
	return _write(fd, text.c_str(), text.length());
}

int writer::_write(int fd, const char* buffer, size_t size)
{
	return ::write(fd, buffer, size);
}

void writer::start()
{
	_start = true;
}

void writer::stop()
{
	_start = false;
}
