/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: response.cpp,v 1.2 2008/01/14 14:48:43 cvsuser Exp $
 */

#include <sl/net/http/response.h>
#include <sl/net/http/http_types.h>
using namespace sl::net::http;


response::response()
	: _status_code(0)
{

}

//
// Override functions.
//

int response::type() const
{
	return msg_type::HTTP_RESPONSE;
}

std::string response::version() const
{
	return _version;
}

void response::start_line(const std::string& s)
{
	message::start_line(s);

	status_line(s);
}

std::string response::start_line() const
{
	return _failed_status_line ? message::start_line() : status_line();
}

void response::cleanup()
{
	_status_code = 0;
	_reason_phrase.clear();
	_version.clear();

	message::cleanup();
}


//
// public functions.
//

void response::status_line(const std::string& s)
{
	/*
	 * Status-Line Υѡ顼ϼʸ򤽤Τޤ
	 * Ѥ礬Τǡ괺¸Ƥ.
	 */
	message::start_line(s);

	std::string tmp = s;

	// Ƭζ̵
	tri_left(tmp);

	for (size_t i = 0; i < tmp.length(); i++) {
		// 򸫤Ĥ¸ tmp  HTTP-VersionʬƤ
		if (tmp[i] == ' ') {
			_version = tmp.substr(0, i);
			tmp.erase(0, i + 1);
			break;
		}
		if (!is_version(tmp[i]))
			throw http_error("invalid HTTP-Version.");
	}

	// HTTP-Version ν³̵
	tri_left(tmp);

	for (size_t i = 0; i < tmp.length(); i++) {
		if (tmp[i] == ' ') {
			_status_code = ::atoi(tmp.substr(0, i).c_str());
			tmp.erase(0, i + 1);
			break;
		}
		if (!isdigit(tmp[i]))
			throw http_error("invalid Status-Code.");
	}

	// Status-Code ν³̵
	tri_left(tmp);

	for (size_t i = 0; i < tmp.length(); i++) {
		if (!is_reason_phrase(tmp[i]))
			throw http_error("invalid reason-phrase.");
	}

	_reason_phrase = tmp;
	tri_right(_reason_phrase);
}

std::string response::status_line() const
{
	std::ostringstream ss;
	ss << status_code();
	return version() + " " + ss.str() + " " + reason_phrase();
}

void response::status_code(int code)
{
	_status_code = code;
	message::start_line(status_line());
}

int response::status_code() const
{
	return _status_code;
}

void response::reason_phrase(const std::string& s)
{
	_reason_phrase = s;
	message::start_line(status_line());
}

std::string response::reason_phrase() const
{
	return _reason_phrase;
}

void response::version(const std::string& s)
{
	_version = s;
	message::start_line(status_line());
}
