/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: request.h,v 1.1 2006/10/28 16:08:25 cvsuser Exp $
 */

#ifndef SL_NET_HTTP_REQUEST_H
#define SL_NET_HTTP_REQUEST_H

#include <map>
#include <string>
#include <vector>

#include <sl/net/http/http_error.h>
#include <sl/net/http/message.h>

namespace sl {
  namespace net {
    namespace http {

	class request: public message {
	public :
		/** Constractor. */
		request();

		/**
		 * message ν貾۴ؿΥС饤.
		 * HTTP Request Ѥ֤ͤޤ.
		 *
		 * @return	int  Request/Response μѤ.
		 */
		virtual int type() const;

		/**
		 * message ν貾۴ؿΥС饤.
		 * ΥꥯȤꤵ줿 HTTPΥСѤʸ֤ޤ.
		 * ⤷ꤵƤʤ϶֤ޤ.
		 *
		 * @return	HTTP ΥСʸ.
		 */
		virtual std::string version() const;

		/**
		 * message β۴ؿΥС饤.
		 * Request ǸȤ Request-Line ꤷޤ.
		 * ºݤˤ request::request_line() ƤӽФǤ.
		 *
		 * @param	line	HTTP ꥯȤΰ.
		 */
		virtual void start_line(const std::string& line);

		/**
		 * message ν貾۴ؿΥС饤.
		 * Request ǸȤ Request-Line ֤ޤ.
		 * ºݤˤ request::request_line() ƤӽФǤ.
		 *
		 * @return	HTTP ꥯȤΰ.
		 */
		virtual std::string start_line() const;

		/**
		 * message β۴ؿΥС饤.
		 * request Τĥѿ򥯥ꥢƤ
		 * message::cleanup() ¹Ԥޤ.
		 */
		virtual void cleanup();

		/**
		 * HTTP ꥯȤ Request-Line ɤ߹ߡ¸ޤ.
		 *  s ѡMethod/Request-URI/Version ʬ䤷¸
		 * ʹߡдؿ method()/uri()/version() Ѥ¸
		 * Ƥ˥Ǥޤ.
		 *  s Υѡ˥顼ȯ㳰 http_error 
		 * ꤲ졢ʹ method()/uri()/version() ֤ͤݾڤޤ.
		 *
		 * @param	HTTP ꥯȤ Request-Line.
		 * @throw	http_error.
		 */
		void request_line(const std::string& s) throw(http_error);

		/**
		 * HTTP ꥯȤ Request-Line ֤ޤ.
		 * Request-Line  method()/uri()/version() ѹǽȤʤ뤿ᡢ
		 * ѹʤ줿硢顼ȯˤä֤ͤѲޤ.
		 *
		 * 1. request_line(s) ˽λǤꡢġ
		 * ¾δؿѹԤʤʤ request_line(s) ¸ͤ
		 * Τޤ֤ޤ.
		 *
		 * 2. request_line(s) ˽λǤꡢġ
		 * ¾δؿѹԤʤä request_line(s) ¸ͤΤ
		 * ѹΤȿǤ줿֤ͤޤ.
		 *
		 * 3. request_line(s) ˽λʤäǤꡢġ
		 * ¾δؿѹԤʤä request_line(s) ¸ͤΤ
		 * ѹΤȿǤ줿֤ͤޤ. ξѹƤʤͤ
		 * ݾڤޤ.
		 *
		 * 4. request_line(s) ˽λʤäǤꡢġ
		 * ¾δؿѹԤʤʤ request_line(s) ¸ߤͤ
		 * Τޤ֤ޤ.
		 *
		 * @return	HTTP ꥯȤ Request-Line.
		 */
		std::string request_line() const;

		/**
		 * HTTP ꥯȤ Request-Line ˤ Method ꤷޤ.
		 *  request_line()  method() ˤä꤬Ƥ
		 * 񤭤ޤ.
		 * ޤδؿǤθϰڹԤʤʤΤǡ
		 * ʸǤФɤͤʤΤǤäƤ⥨顼֤ޤ.
		 *
		 * @param	line	HTTP ꥯȤMethod.
		 */
		void method(const std::string& s);

		/**
		 * HTTPꥯȤ Request-Line ˤ Method ֤ޤ.
		 * ⤷٤ Method ꡢԤʤƤʤ
		 * ʸ֤ޤ.
		 *
		 * @return	HTTP ꥯȤMethod.
		 */
		std::string method() const;

		/**
		 * HTTP ꥯȤ Request-Line ˤ Request-URI ꤷޤ.
		 *  request_line()  uri() ˤä꤬Ƥ
		 * 񤭤ޤ.
		 * δؿǤθϰڹԤʤʤΤǡ
		 * ʸǤФɤͤʤΤǤäƤ⥨顼֤ޤ.
		 * ޤ s  Query-String ޤޤƤǤäƤ
		 *  Request-URI Ȥ¸졢Query-String ϰѹޤ.
		 *
		 * @param	line	HTTP ꥯȤURI.
		 */
		void uri(const std::string& s);

		/**
		 * HTTPꥯȤ Request-Line ˤ Request-URI ֤ޤ.
		 * ⤷٤ Request-URI ꡢԤʤƤʤ
		 * ʸ֤ޤ.
		 *
		 * @return	HTTP ꥯȤURI.
		 */
		std::string uri() const;

		/**
		 * HTTP ꥯȤ Request-Line ˤ HTTP-Version ꤷޤ.
		 *  request_line()  version() ˤä꤬Ƥ
		 * 񤭤ޤ.
		 * ޤδؿǤθϰڹԤʤʤΤǡ
		 * ʸǤФɤͤʤΤǤäƤ⥨顼֤ޤ.
		 *
		 * @param	line	HTTP ꥯȤHTTP-Version.
		 */
		void version(const std::string& s);

		/**
		 * HTTP ꥯȤ Request-Line ˤ Request-URI  Query-String 
		 * ղäޤ.
		 *  request_line(string)  Query-String ꤬Ƥ
		 * 񤭤ޤ.
		 *
		 * @param	s	HTTP ꥯȤ Query-String.
		 */
		void query_string(const std::string& s);

		/**
		 * HTTP ꥯȤ Request-Line ˤ Request-URI  Query-String 
		 * ֤ޤ.
		 * request_line()/uri() ˤä Request-Line ѹ
		 * δؿ֤ͤѹޤ.
		 * ⤷٤ Request-URI  Query-String ꡢ
		 * ԤʤƤʤ϶ʸ֤ޤ.
		 *
		 * @return	HTTP ꥯȤ Query-String.
		 */
		std::string query_string() const;

		/**
		 * Query-String  "="/"&" ʬ䤷ޥåפ֤ޤ.
		 * Υޥåפ֤ Query-String νɤ߹Ǥ.
		 *
		 * @return Query-String Υޥå.
		 */
		ordermap_t query() const;

		/**
		 * ꥯȤꤵ줿 ѥ᡼Υޥåפ֤ޤ.
		 * δؿˤä֤ͤ POST ᥽åɤǤꡢġ
		 * Content-Type إå "application/x-www-form-urlencoded"Ǥ
		 * ܥǥʬ䤷ޥåפǤ.
		 *
		 * @return	POST ǡΥѥ᡼Υޥå.
		 */
		ordermap_t parameter() const;

		/**
		 * ΥꥯȤꤵƤѥ᡼Τ
		 *  name ĥѥ᡼ͤΥꥹȤ֤ޤ.
		 *
		 * @param	name	ѥ᡼̾.
		 * @return	 name ĥѥ᡼ vector.
		 */
		std::vector<std::string> parameter(const std::string& name) const;

		void cookie(const std::string& n, const multimap_t& v);
		multimap_t cookie(const std::string& name) const;
		std::multimap<std::string, multimap_t> cookies() const;

	protected :
		std::string	_method;
		std::string _version;
		std::string _uri;
		std::string _query_string;
		ordermap_t	_parameters;

		/**
		 * Request-Line ֤ݻޤ.
		 * Υե饰Ͻͤ false ȤƤꡢ
		 * start_line() ͳǤ Request-Line ͤꤵ줿硢
		 * ޤϡmethod()/uri()/version()/query() Ѥ
		 * Request-Line 򹹿 true Ȥʤޤ.
		 *
		 * Υե饰 message::text() ư˱ƶͿ
		 * false ξ message::text() ¹Ԥ request_line() 
		 * ͤѤ message::start_line() ֤ͤޤ.
		 * true ξ message::text() ¹Ԥ request_line() 
		 * ͤѤޤ.
		 * Υե饰 cleanup() ¹Ԥǽ(false)ޤ.
		 */
		bool	_use_request_line;
	};

    } // namespace http
  } // namespace net
} // namespace sl

#endif // SL_NET_HTTP_REQUEST_H
