/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: request.cpp,v 1.2 2008/01/14 14:48:43 cvsuser Exp $
 */

#include <iostream>

#include <sl/net/http/http_function.h>
#include <sl/net/http/http_error.h>
#include <sl/net/http/request.h>
#include <sl/net/http/http_types.h>
using namespace sl::net::http;


//
// Constractor.
//

request::request()
	: _use_request_line(false)
{
	cleanup();
}


//
// Override functions.
//

int request::type() const
{
	return msg_type::HTTP_REQUEST;
}

void request::start_line(const std::string& s)
{
	request_line(s);
}

std::string request::start_line() const
{
	return _use_request_line ? request_line() : message::start_line();
}

//
// public functions.
//

void request::cleanup()
{
	_method.clear();
	_version.clear();
	_uri.clear();
	_query_string.clear();
	_parameters.clear();
	_use_request_line = false;

	message::cleanup();
}

void request::request_line(const std::string& s) throw (http_error)
{
	/*
	 * Request-Line Υѡ顼ϼʸ򤽤Τޤ
	 * Ѥ礬Τǡ괺¸Ƥ.
	 */
	message::start_line(s);

	std::string tmp = s;

	// Ƭζ̵
	tri_left(tmp);

	for (size_t i = 0; i < tmp.length(); i++) {
		// 򸫤Ĥ¸ tmp ϥ᥽åʬƤ
		if (tmp[i] == ' ') {
			_method = tmp.substr(0, i);
			tmp.erase(0, i + 1);
			break;
		}
		if (!isalnum(tmp[i]))
			throw http_error("invalid Method.");
	}

	// ᥽åν³̵
	tri_left(tmp);

	for (size_t i = 0; i < tmp.length(); i++) {
		if (tmp[i] == ' ' || tmp[i] == '?') {
			_uri = tmp.substr(0, i);
			tmp.erase(0, i);		// Ǥ ' ' ޤ '?' ĤƤ
			break;
		}
		if (!is_uri(tmp[i]))
			throw http_error("invalid Request-URI.");
	}

	// '?' Ǥ query string Ȥ¸
	if (tmp[0] == '?') {
		tmp.erase(0, 1);
		for (size_t i = 0; i < tmp.length(); i++) {
			if (tmp[i] == ' ') {
				_query_string = tmp.substr(0, i);
				tmp.erase(0, i + 1);
				break;
			}
			if (!is_query_string(tmp[i]))
				throw http_error("invalid Query-String.");
		}
	}

	// URIν³̵
	tri_left(tmp);

	for (size_t i = 0; i < tmp.length(); i++) {
		if (!is_version(tmp[i]))
			throw http_error("invalid HTTP-Version.");
	}

	_version = tmp;
	tri_right(_version);

	_use_request_line = true;
}

std::string request::request_line() const
{
	std::string q;
	if (!query_string().empty())
		q = "&" + query_string();

	return method() + " " + uri() + q + " " + version();
}

void request::method(const std::string& s)
{
	_method = s;
	message::start_line(request_line());
	_use_request_line = true;
}

std::string request::method() const
{
	return _method;
}

void request::version(const std::string& s)
{
	_version = s;
	message::start_line(request_line());
	_use_request_line = true;
}

std::string request::version() const
{
	return _version;
}

void request::uri(const std::string& s)
{
	_uri = s;
	message::start_line(request_line());
	_use_request_line = true;
}
std::string request::uri() const
{
	return _uri;
}

void request::query_string(const std::string& s)
{
	_query_string = s;
	message::start_line(request_line());
	_use_request_line = true;
}

std::string request::query_string() const
{
	return _query_string;
}

ordermap_t request::query() const
{
	ordermap_t	result;

	const std::string& s = _query_string;
	if (s.empty())
		return result;

	std::string::size_type cur, pos;

	for (cur = 0; cur <= s.length();) {
		pos = s.find('=', cur);
		if (pos == std::string::npos) {
			result.push_back(std::make_pair(s.substr(cur), ""));
			break;
		}
		std::string name(s.substr(cur, pos - cur));
		cur = pos + 1;

		pos = s.find('&', cur);
		if (pos != std::string::npos) {
			result.push_back(std::make_pair(name,s.substr(cur,pos - cur)));
			cur = pos + 1;
		} else {
			result.push_back(std::make_pair(name, s.substr(cur)));
			break;
		}
	}

	return result;
}

ordermap_t request::parameter() const
{
	ordermap_t	result;

	if (!has_parameter(*this))
		return result;

	const std::string& s = this->msg_body();
	if (s.empty())
		return result;

	std::string::size_type cur, pos;

	for (cur = 0; cur <= s.length();) {
		pos = s.find('=', cur);
		if (pos == std::string::npos) {
			result.push_back(std::make_pair(s.substr(cur), ""));
			break;
		}
		std::string name(s.substr(cur, pos - cur));
		cur = pos + 1;

		pos = s.find('&', cur);
		if (pos != std::string::npos) {
			result.push_back(std::make_pair(name,s.substr(cur,pos - cur)));
			cur = pos + 1;
		} else {
			result.push_back(std::make_pair(name, s.substr(cur)));
			break;
		}
	}

	return result;
}

std::vector<std::string> request::parameter(const std::string& name) const
{
	std::vector<std::string> result;

	ordermap_t params = parameter();
	ordermap_t::const_iterator i = params.begin();
	for (; i != params.end(); i++) {
		if (i->first == name)
			result.push_back(i->second);
	}
	return result;
}

// XXXXX
void request::cookie(const std::string& /* n */, const multimap_t& v)
{
	std::string value;

	for (multimap_t::const_iterator i = v.begin(); i != v.end(); i++) {
		value += i->first + "=" + i->second;
//		if ((i+1) != v.end())
			value += "; ";
	}
	msg_header("Set-Cookie", value);
}

multimap_t request::cookie(const std::string& /* name */) const
{
	multimap_t dummy;
	return dummy;
}

std::multimap<std::string, multimap_t> request::cookies() const
{
	std::multimap<std::string, multimap_t> dummy;
	return dummy;
}
