/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: reader.h,v 1.1 2006/10/28 16:08:25 cvsuser Exp $
 */

#ifndef SL_NET_HTTP_READER_H
#define SL_NET_HTTP_READER_H

#include <time.h>

#include <sl/net/http/message.h>

namespace sl {
  namespace net {
    namespace http {

	class reader {
	public :
		reader();

		virtual ~reader() { }

		int read(int fd, message& msg,
				 time_t header_timeout, time_t body_timeout);

		void start();

		void stop();

		virtual int _read(int fd, char *buffer, size_t size);

	private :
		int partial_reading(std::string& remains, const std::string& newbuf,
							message& msg);

		int partial_body_reading(std::string& remains, message& msg,
								 size_t l);

		bool fd_select(int fd, time_t timeout);

		volatile bool _start;
	};

    } // namespace http
  } // namespace net
} // namespace sl

#endif // SL_NET_HTTP_READER_H
