/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: message.h,v 1.6 2008/01/14 14:48:43 cvsuser Exp $
 */

#ifndef SL_NET_HTTP_MESSAGE_H
#define SL_NET_HTTP_MESSAGE_H

#include <string>

#include <sl/net/http/http_types.h>

namespace sl {
  namespace net {
    namespace http {

	class message {
	public :

		/** constructor. */
		message();

		/** destructor. */
		virtual ~message() { };

		/**
		 * HTTP-Message Υפ֤ν貾۴ؿǤ.
		 * HTTP-Request ޤϡHTTP-Response Ѥ֤ͤޤ.
		 *
		 * @return	int  Request/Response μѤ.
		 */
		virtual int type() const=0;

		/**
		 * HTTP-Version ֤ν貾۴ؿǤ.
		 * ΥꥯȤꤵ줿 HTTPΥСѤʸ֤ޤ.
		 * ⤷ꤵƤʤ϶֤ޤ.
		 *
		 * @return	HTTP ΥСʸ.
		 */
		virtual std::string version() const=0;

		/**
		 * ꥯȤꤵƤƤξޤ.
		 * ʹߡ٤ parse()  ¾ΥǡѴؿˤ
		 * ʥǡ꤬ʤޤǡ text() ǡѤδؿˤä
		 * ֤ͤݾڤޤ.
		 */
		virtual void cleanup();

		/**
		 * ƥȥե뤫 HTTPǡɤ߹ߤԤʤޤ.
		 * 顼ȯ http_error ꤲ졢
		 * ʹߡ٤ parse()  ¾ΥǡѴؿˤ
		 * ʥǡ꤬ʤޤǡ text() ǡѤδؿˤä
		 * ֤ͤݾڤޤ.
		 *
		 * @param	text	HTTPꥯ/HTTP쥹ݥ󥹤ꤷ string.
		 */
		virtual void parse(const std::string& text);

		/**
		 * ˥ǡɤ߹िδؿǤ.
		 * ɤ߹ߤνȤơ
		 * 1. start_line() Ǥ start_line() ¹Ԥޤ.
		 * 2. start_line() Ǥʤ parse_line() ¹Ԥ
		 * ƹԤإåեɤȤ¸Ƥޤ.
		 *
		 * @param	line	HTTP-Message ΰԤ string.
		 */
		virtual void add_line(const std::string& line);

		/**
		 * HTTP-Message ΰܤꤷޤ.
		 * HTTP-Message  Start-Line ϡHTTP-Request  Request-Line
		 * HTTP-Response  Status-Line ƱǤ.
		 *
		 * @param	line	HTTP-Message ΰܤ string.
		 */
		virtual void start_line(const std::string& line);

		/**
		 * HTTP-Message ΰܤ֤ޤ.
		 * HTTP-Message  Start-Line ϡHTTP-Request  Request-Line
		 * HTTP-Response  Status-Line ƱǤ.
		 *
		 * @return	HTTP-Message ΰܤ string.
		 */
		virtual std::string start_line() const;

		/**
		 *  code إå̾ȤѴ塢"code: value" η¸ޤ.
		 * @param	code	general_code 򻲾.
		 * @param	value	 code Фإåեɤ.
		 */
		void msg_header(int code, const std::string& value);

		/**
		 *  code إå̾Ȥ"code: value" η¸ޤ.
		 *  code Ʊ̾ĥإåեɤ¸ߤƤƤ
		 * "code: value" ϹԤʤ졢value ͤޤƱǤ
		 * value ͤǾ񤭤ޤ.
		 *
		 * @param	name	general_code 򻲾.
		 * @param	value	 code Фإåեɤ.
		 */
		void msg_header(const std::string& name, const std::string& value);

		/**
		 *  name إåե̾ĥإåեɤ֤ͤޤ.
		 * name ͤ̾ȤƤĥإåեɤʣ¸ߤƤ
		 * Ƭ(ɤ߹ߤԤʤä)Ԥ֤ޤ.
		 *
		 * @return	إåեɤ.
		 */
		std::string msg_header(const std::string& name) const;

		/**
		 *  code إå̾ȤѴ塢Υإå̾
		 * إåեɤ֤ͤޤ.
		 * name ͤ̾ȤƤĥإåեɤʣ¸ߤƤ
		 * Ƭ(ɤ߹ߤԤʤä)Ԥ֤ޤ.
		 *
		 * @param	code	إå̾Υ.
		 * @return	إåեɤ.
		 */
		std::string msg_header(int code) const;

		/**
		 *  name إåե̾Ȥƻĥإåեɤͤ
		 * ꥹȤˤ֤ޤ.
		 * name ͤ̾ȤƤĥإåեɤʣ¸ߤƤ
		 * Ƭ(ɤ߹ߤԤʤä)إå龺Ԥ֤ޤ.
		 *
		 * @param	name	إå̾.
		 * @return	إåեɤ.
		 */
		list_t msg_headers(const std::string& name) const;

		/**
		 *  code إå̾ȤѴ塢Υإå̾
		 * إåեɤͤꥹȤˤ֤ޤ.
		 * name ͤ̾ȤƤĥإåեɤʣ¸ߤƤ
		 * Ƭ(ɤ߹ߤԤʤä)إå龺Ԥ֤ޤ.
		 *
		 * @return	إåեɤ.
		 */
		list_t msg_headers(int code) const;

		/**
		 * ݻƤإåեɤ̾ͤΥڥޥåפȤ֤ޤ.
		 *
		 * @return	إåեɤ̾ͤΥޥå.
		 */
		multimap_t msg_headers() const;

		/**
		 *  name ǻꤵ줿إåե̾
		 * ƤΥإåեɤޤ.
		 *
		 * @param	name	إå̾.
		 */
		void erase_header(const std::string& name);

		/**
		 *  body 򥳥ƥĥܥǥȤ¸ޤ.
		 * ˥ܥǥȤꤵƤƤ˴ޤ.
		 *
		 * @param	body	ƥĤΥܥǥȤꤹ.
		 */
		void msg_body(const std::string& body);

		/**
		 *  body 򥳥ƥĥܥǥȤɲäޤ.
		 * ˥ܥǥȤꤵƤƤ¸ߤƤϡ
		 * ͤ˰ body Ƥɲäޤ.
		 *
		 * @param	partial	ƥĤΥܥǥȤꤹ.
		 */
		void add_body(const std::string& partial);

		/**
		 * HTTP-Message λĥƥĤΥܥǥ֤ޤ.
		 *
		 * @return	ƥĥܥǥ.
		 */
		std::string msg_body() const;

		/**
		 * ꤵƤƤ HTTP-Message η֤ޤ.
		 *
		 * @return	HTTP-Message  string.
		 */
		std::string text() const;

		/**
		 * ꥯȤФղþꤷޤ.
		 * ϼ˰۾ʥꥯȤξ message Ѥ¦
		 * ٤˻Ѥ졢text() ǤϰڽϤޤ.
		 *
		 * @param	n	ꤹ̾.
		 * @param	v	ꤹ.
		 */
		void attribute(const std::string& n, const std::string& v);

		/**
		 * ꥯȤФꤵƤղþ֤ޤ.
		 * ϼ˰۾ʥꥯȤξ message Ѥ¦
		 * ٤˻Ѥ졢text() ǤϰڽϤޤ.
		 *
		 * @param	name	ꤹ̾.
		 * @return	ꤹ.
		 */
		std::string attribute(const std::string& name) const;

		/**
		 * ꥯȤФꤵƤղþΥޥåפ֤ޤ.
		 *
		 * @return	ꤹ̾ͤΥޥå.
		 */
		multimap_t attribute() const;

		/**
		 * ꥯȤФꤵƤղþޤ.
		 *
		 * @param	name	ꤹ̾.
		 */
		void erase_attribute(const std::string& name);

		/**
		 * HTTP-Message λĤ٤ƤΥإåƥȤȤ֤ޤ.
		 *
		 * @return	ƥȤѴإå.
		 */
		std::string text_header() const;

		/**
		 * HTTP-Message λĥƥĤΥܥǥ֤ޤ.
		 *
		 * @return	ƥȤѴƥĥܥǥ.
		 */
		std::string text_body() const;

		/**
		 * HTTP-Message λĥܥǥ iostream Ȥ¸ޤ.
		 *
		 * @param	ifs		std::istream ֥.
		 */
		void stream(std::iostream& ifs);

		/**
		 * HTTP-Message λĥܥǥ istream Ȥ֤ޤ.
		 *
		 * @return		std::iostream ֥.
		 */
		std::iostream& stream();

	protected :
		/**
		 * add_line() ¹Ԥ졢 line إåեɤȤ
		 * ":" ˤäʬ䤷msg_header() ѤƥإåȤ¸ޤ.
		 *
		 * @param	line HTTP-Message Υإåեɤΰ.
		 */
		virtual void parse_line(const std::string& line);

		std::string		_start_line;
		multimap_t		_headers_map;
		multimap_t		_attr_map;
		std::string		_body;
		std::iostream*	_stream;
	};

    } // namespace http
  } // namespace net
} // namespace sl

#endif // SL_NET_HTTP_MESSAGE_H
