/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: http_types.cpp,v 1.9 2008/01/14 14:51:04 cvsuser Exp $
 */

#include <iostream>
#include <string>
#include <map>

#include <sl/net/http/http_types.h>

namespace sl {
  namespace net {
    namespace http {

	const int msg_type::HTTP_REQUEST	= 0x1000;
	const int msg_type::HTTP_RESPONSE	= 0x1001;

	const int method_code::OPTIONS	= 0;
	const int method_code::GET		= 1;
	const int method_code::HEAD		= 2;
	const int method_code::POST		= 3;
	const int method_code::PUT		= 4;
	const int method_code::DELETE	= 5;
	const int method_code::TRACE	= 6;
	const int method_code::CONNECT	= 7;

	method_code::method_code()
	{
		_map[OPTIONS]	= "OPTIONS";
		_map[GET]		= "GET";
		_map[HEAD]		= "HEAD";
		_map[POST]		= "POST";
		_map[PUT]		= "PUT";
		_map[DELETE]	= "DELETE";
	}


	// 1. Informational 1xx
	const int status_code::CONTINUE							= 100;
	const int status_code::SWITCHING_PROTOCOLS				= 101;

	// 2. Successful 2xx
	const int status_code::OK								= 200;
	const int status_code::CREATED							= 201;
	const int status_code::ACCEPTED							= 202;
	const int status_code::NON_AUTHORITATIVE_INFORMATION	= 203;
	const int status_code::NO_CONTENT						= 204;
	const int status_code::RESET_CONTENT					= 205;
	const int status_code::PARTIAL_CONTENT					= 206;

	// 3. Redirection 3xx
	const int status_code::MULTIPLE_CHOICES					= 300;
	const int status_code::MOVED_PERMANENTLY				= 301;
	const int status_code::FOUND							= 302;
	const int status_code::SEE_OTHER						= 303;
	const int status_code::NOT_MODIFIED						= 304;
	const int status_code::USE_PROXY						= 305;
	//const int status_code::(Unused)						= 306;
	const int status_code::TEMPORARY_REDIRECT				= 307;

	// 4. Client Error 4xx
	const int status_code::BAD_REQUEST						= 400;
	const int status_code::UNAUTHORIZED						= 401;
	const int status_code::PAYMENT_REQUIRED					= 402;
	const int status_code::FORBIDDEN						= 403;
	const int status_code::NOT_FOUND						= 404;
	const int status_code::METHOD_NOT_ALLOWED				= 405;
	const int status_code::NOT_ACCEPTABLE					= 406;
	const int status_code::PROXY_AUTHENTICATION_REQUIRED	= 407;
	const int status_code::REQUEST_TIMEOUT					= 408;
	const int status_code::CONFLICT							= 409;
	const int status_code::GONE								= 410;
	const int status_code::LENGTH_REQUIRED					= 411;
	const int status_code::PRECONDITION_FAILED				= 412;
	const int status_code::REQUEST_ENTITY_TOOLARGE			= 413;
	const int status_code::REQUEST_URI_TOOLONG				= 414;
	const int status_code::UNSUPPORTED_MEDIATYPE			= 415;
	const int status_code::REQUESTED_RANGE_NOTSATISFIABLE	= 416;
	const int status_code::EXPECTATION_FAILED				= 417;

	// 5. Server Error 5xx
	const int status_code::INTERNAL_SERVER_ERROR			= 500;
	const int status_code::NOT_IMPLEMENTED					= 501;
	const int status_code::BAD_GATEWAY						= 502;
	const int status_code::SERVICE_UNAVAILABLE				= 503;
	const int status_code::GATEWAY_TIMEOUT					= 504;
	const int status_code::HTTPVERSION_NOT_SUPPORTED		= 505;


	status_code::status_code()
	{
		// 1. Informational 1xx
		_map[CONTINUE]						= "Continue";
		_map[SWITCHING_PROTOCOLS]			= "Switching Protocols";

		// 2. Successful 2xx
		_map[OK]							= "OK";
		_map[CREATED]						= "Created";
		_map[ACCEPTED]						= "Accepted";
		_map[NON_AUTHORITATIVE_INFORMATION]	= "Non-Authoritative Information";
		_map[NO_CONTENT]					= "No Content";
		_map[RESET_CONTENT]					= "Reset Content";
		_map[PARTIAL_CONTENT]				= "Partial Content";

		// 3. Redirection 3xx
		_map[MULTIPLE_CHOICES]				= "Multiple Choices";
		_map[MOVED_PERMANENTLY]				= "Moved Permanently";
		_map[FOUND]							= "Found";
		_map[SEE_OTHER]						= "See Other";
		_map[NOT_MODIFIED]					= "Not Modified";
		_map[USE_PROXY]						= "Use Proxy";
	//	_map[(Unused)]						= "(Unused)";
		_map[TEMPORARY_REDIRECT]			= "Temporary Redirec";

		// 4. Client Error 4xx
		_map[BAD_REQUEST]					= "Bad Request";
		_map[UNAUTHORIZED]					= "Unauthorized";
		_map[PAYMENT_REQUIRED]				= "Payment Required";
		_map[FORBIDDEN]						= "Forbidden";
		_map[NOT_FOUND]						= "Not Found";
		_map[METHOD_NOT_ALLOWED]			= "Method Not Allowed";
		_map[NOT_ACCEPTABLE]				= "Not Acceptable";
		_map[PROXY_AUTHENTICATION_REQUIRED]	= "Proxy Authentication Required";
		_map[REQUEST_TIMEOUT]				= "Request Timeout";
		_map[CONFLICT]						= "Conflict";
		_map[GONE]							= "Gone";
		_map[LENGTH_REQUIRED]				= "Length Required";
		_map[PRECONDITION_FAILED]			= "Precondition Failed";
		_map[REQUEST_ENTITY_TOOLARGE]		= "Request Entity Too Large";
		_map[REQUEST_URI_TOOLONG]			= "Request URI TooLong";
		_map[UNSUPPORTED_MEDIATYPE]			= "Unsupported MediaType";
		_map[REQUESTED_RANGE_NOTSATISFIABLE]= "Requested Range Not Satisfiable";
		_map[EXPECTATION_FAILED]			= "Expectation Failed";

		// 5. Server Error 5xx
		_map[INTERNAL_SERVER_ERROR]			= "Internal Server Error";
		_map[NOT_IMPLEMENTED]				= "Not Implemented";
		_map[BAD_GATEWAY]					= "Bad Gateway";
		_map[SERVICE_UNAVAILABLE]			= "Service Unavailable";
		_map[GATEWAY_TIMEOUT]				= "Gateway Timeout";
		_map[HTTPVERSION_NOT_SUPPORTED]		= "HTTP Version Not Supported";
	}


	const int general_header_code::Cache_Control	= 0x0101;
	const int general_header_code::Connection		= 0x0102;
	const int general_header_code::Date				= 0x0103;
	const int general_header_code::Pragma			= 0x0104;
	const int general_header_code::Trailer			= 0x0103;
	const int general_header_code::Transfer_Encoding= 0x0105;
	const int general_header_code::Upgrade			= 0x0106;
	const int general_header_code::Via				= 0x0107;
	const int general_header_code::Warning			= 0x0108;

	const int general_header_code::Allow			= 0x0201;
	const int general_header_code::Content_Encoding	= 0x0202;
	const int general_header_code::Content_Language	= 0x0203;
	const int general_header_code::Content_Length	= 0x0204;
	const int general_header_code::Content_Location	= 0x0205;
	const int general_header_code::Content_MD5		= 0x0206;
	const int general_header_code::Content_Range	= 0x0207;
	const int general_header_code::Content_Type		= 0x0208;
	const int general_header_code::Expires			= 0x0209;
	const int general_header_code::Last_Modified	= 0x020a;

	general_header_code::general_header_code()
	{
		_map[Cache_Control]		= "Cache-Control";
		_map[Connection]		= "Connection";
		_map[Date]				= "Date";
		_map[Pragma]			= "Pragma";
		_map[Trailer]			= "Trailer";
		_map[Transfer_Encoding]	= "Transfer-Encoding";
		_map[Upgrade]			= "Upgrade";
		_map[Via]				= "Via";
		_map[Warning]			= "Warning";

		_map[Allow]				= "Allow";
		_map[Content_Encoding]	= "Content-Encoding";
		_map[Content_Language]	= "Content-Language";
		_map[Content_Length]	= "Content-Length";
		_map[Content_Location]	= "Content-Location";
		_map[Content_MD5]		= "Content-MD5";
		_map[Content_Range]		= "Content-Range";
		_map[Content_Type]		= "Content-Type";
		_map[Expires]			= "Expires";
		_map[Last_Modified]		= "Last-Modified";
	}


	const int request_header_code::Accept			= 0x0301;
	const int request_header_code::Accept_Charset	= 0x0302;
	const int request_header_code::Accept_Encoding	= 0x0303;
	const int request_header_code::Accept_Language	= 0x0304;
	const int request_header_code::Autorization		= 0x0305;
	const int request_header_code::Expect			= 0x0306;
	const int request_header_code::Form				= 0x0307;
	const int request_header_code::Host				= 0x0308;
	const int request_header_code::If_Match			= 0x0309;
	const int request_header_code::If_Modified_Since= 0x030a;
	const int request_header_code::If_None_Match	= 0x030b;
	const int request_header_code::If_Range			= 0x030c;
	const int request_header_code::If_Unmodified_Since	= 0x030d;
	const int request_header_code::Max_Forwards			= 0x030e;
	const int request_header_code::Proxy_Authorization	= 0x030f;
	const int request_header_code::Range			= 0x0310;
	const int request_header_code::Referer			= 0x0311;
	const int request_header_code::TE				= 0x0312;
	const int request_header_code::User_Agent		= 0x0313;

	request_header_code::request_header_code()
	{
		_map[Accept]				= "Accept";
		_map[Accept_Charset]        = "Accept-Charset";
		_map[Accept_Encoding]       = "Accept-Encoding";
		_map[Accept_Language]       = "Accept-Language";
		_map[Autorization]          = "Autorization";
		_map[Expect]                = "Expect";
		_map[Form]                  = "Form";
		_map[Host]                  = "Host";
		_map[If_Match]              = "If-Match";
		_map[If_Modified_Since]     = "If-Modified-Since";
		_map[If_None_Match]         = "If-None-Match";
		_map[If_Range]              = "If-Range";
		_map[If_Unmodified_Since]   = "If-Unmodified_Since";
		_map[Max_Forwards]          = "Max-Forwards";
		_map[Proxy_Authorization]   = "Proxy-Authorization";
		_map[Range]                 = "Range";
		_map[Referer]               = "Referer";
		_map[TE]                    = "TE";
		_map[User_Agent]            = "User-Agent";
	}

	const int response_header_code::Accept_Ranges		= 0x0401;
	const int response_header_code::Age					= 0x0402;
	const int response_header_code::ETag				= 0x0403;
	const int response_header_code::Location			= 0x0404;
	const int response_header_code::Proxy_Authenticate	= 0x0405;
	const int response_header_code::Retry_After			= 0x0406;
	const int response_header_code::Server				= 0x0407;
	const int response_header_code::Vary				= 0x0408;
	const int response_header_code::WWW_Authenticate	= 0x0409;

	response_header_code::response_header_code()
	{
		_map[Accept_Ranges]		= "Accept-Ranges";
		_map[Age]				= "Age";
		_map[ETag]				= "ETag";
		_map[Location]			= "Location";
		_map[Proxy_Authenticate]= "Proxy-Authenticate";
		_map[Retry_After]		= "Retry-After";
		_map[Server]			= "Server";
		_map[Vary]				= "Vary";
		_map[WWW_Authenticate]	= "WWW-Authenticate";
	}


    } // namespace http
  } // namespace net
} // namespace sl
