/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: http_function.h,v 1.12 2008/01/14 14:51:04 cvsuser Exp $
 */

#ifndef SL_NET_HTTP_FUNCTION_H
#define SL_NET_HTTP_FUNCTION_H

#include <iostream>
#include <sstream>


namespace sl {
  namespace net {
    namespace http {

	class message;

	namespace core {

        struct is_iequal {
            bool operator()(char l, char r) const
            {
                return tolower(l) == tolower(r);
            }
        };

        /**
         * ʸʸ̤ӤԤʤؿǤ.
         * إå°ʸӤԤʤ˻Ѥޤ.
         * @param   l   ʸ.
         * @param   r   ʸ.
         * @return  true : Ʊ, false : ۤʤ.
         */
        template <class Predicate>
        bool equals(const std::string &l, const std::string &r, Predicate p)
        {
            if (l.length() != r.length())
                return false;

            size_t length = l.length();
            for (size_t i = 0; i < length; i++) {
                if (!p(l[i], r[i]))
                    return false;
            }
            return true;
        }

	} // namespace core


	inline void tri_left(std::string& s)
	{
		size_t i = 0;
		for (; i < s.length() && s[i] == ' '; i++)
			/* noting */ ;
		s.erase(0, i);
	}

	inline std::string tri_left_copy(std::string& s)
	{
		tri_left(s);
		return s;
	}

	inline void tri_right(std::string& s)
	{
		size_t i, length;
		i = length = s.length() - 1;
		for (; i > 0 && s[i] == ' '; i--)
			/* noting */ ;
		s.erase(i + 1, length + 1);
	}

	inline std::string tri_right_copy(std::string& s)
	{
		tri_right(s);
		return s;
	}

	/**
	 *  allow_char ˰ c ޤޤƤ뤫ȽԤʤޤ.
	 *
	 * @param	allow_char	ȽѤʸ.
	 * @param	char_num	allow_char ʸ.
	 * @param	c			ȽΥåȤȤʤʸ.
	 * @return	true:ޤޤ	false:ޤޤʤ.
	 */
	inline bool is_allow(const char* allow_char, size_t char_num, const char c)
	{
		return std::find(allow_char + 0, allow_char + char_num, c) != '\0';
	}

	/**
	 *  c  Http-Request  Request-URI ȤƵƤʸǤ뤫
	 * ȽԤʤޤ.
	 * δؿˤäƵƤʸ '/'':''_''-''.''%' Ǥ
	 *
	 * @param	c	ȽΥåȤȤʤʸ.
	 */
	inline bool is_uri(const char c)
	{
		static const char allow_char[] = { "/:_-.%" };
		return isalnum(c) || is_allow(allow_char, sizeof(allow_char), c);
	}

	/**
	 *  c  Http-Message  HTTP-Version ȤƵƤʸǤ뤫
	 * ȽԤʤޤ.
	 * δؿˤäƵƤʸ 'H''T''P''/''.' Ǥ
	 *
	 * @param	c	ȽΥåȤȤʤʸ.
	 */
	inline bool is_version(const char c)
	{
		static const char allow_char[] = { "HTP/." };
		return isdigit(c) || is_allow(allow_char, sizeof(allow_char), c);
	}

	/**
	 *  c  Http-Request  Query-String ȤƵƤʸǤ뤫
	 * ȽԤʤޤ.
	 * δؿˤäƵƤʸ '_''-''.''%''?'';''&' Ǥ
	 *
	 * @param	c	ȽΥåȤȤʤʸ.
	 */
	inline bool is_query_string(const char c)
	{
		static const char allow_char[] = { "_-.%?=;&" };
		return isalnum(c) || is_allow(allow_char, sizeof(allow_char), c);
	}

	/**
	 *  c  Http-Response  Reason-Phrase ȤƵƤʸǤ뤫
	 * ȽԤʤޤ.
	 * δؿˤäƵƤʸ ' ' Ǥ
	 *
	 * @param	c	ȽΥåȤȤʤʸ.
	 */
	inline bool is_reason_phrase(const char c)
	{
		static const char allow_char[] = { " " };
		return isprint(c) || is_allow(allow_char, sizeof(allow_char), c);
	}

	inline char atoh(char c)
	{
		if (('0' <= c) && (c <= '9')) return c - '0';
		if (('A' <= c) && (c <= 'F')) return c - 'A' + 10;
		if (('a' <= c) && (c <= 'f')) return c - 'a' + 10;
		return 0;
	}

	inline char htoa(char c)
	{
		if ((0x0 <= c) && (c <= 0x9)) return c + '0';
		if ((0xa <= c) && (c <= 0xf)) return c + 'A' - 0xa;
		return 0;
	}

	/**
	 *  msg ѥ᡼ĤȽԤʤޤ.
	 * ᥽åɤ POST Ǥꡢ Content-Type  "" Ǥ뤫
	 * Ƚꤷޤ.
	 *
	 * @param	msg		HTTP-Message.
	 * @return	true:ѥ᡼	false:ѥ᡼ʤ
	 */
	bool has_parameter(const message& msg);

	/**
	 *  msg ƤȽꤷƥĤΥܥǥ chunked Ǥ뤫
	 * ȽԤʤޤ.
	 *
	 * @param	msg		HTTP-Message.
	 * @return	true:chunkedǤ	false:chunkedǤʤ.
	 */
    bool is_chunked(const message& msg);

	/**
	 *  msg ƤȽꤷƥĤΥܥǥĹ֤ޤ.
	 * ⤷HTTP-Message  ܥǥĹȽʤ -1 ֤ޤ.
	 *
	 * @param	msg		HTTP-Message.
	 * @return	ƥĹ.
	 */
	int content_length(const message& msg);

	/**
	 *  s URL󥳡ɤԤʤäʸ֤ޤ.
	 *
	 * @param	s	URL󥳡оݤʸ.
	 * @return	URL󥳡ɸʸ.
	 */
	std::string urlencode(const std::string& s);

	/**
	 *  s URLǥɤԤʤäʸ֤ޤ.
	 *
	 * @param	s	URLǥоݤʸ.
	 * @return	URLǥɸʸ.
	 */
	std::string urldecode(const std::string& s);


	std::string& erase_crlf(std::string& s);

	void read_line(std::iostream& ifs, std::string& s);

	int read_message(std::iostream& ifs, message& msg);

	void write_headers(std::iostream& os, message& msg);

	void write_body(std::iostream& os, message& msg);

	/**
	 * åȤ˻ĤäƤޤߥǡɤ߹ߤޤ.
	 * @param	fd		ɤ߹оݤΥեǥץ.
	 * @param	length	ĤΥߥǡĹ. ʾ 0 ꤷޤ.
	 */
	void read_unnecessary(int fd, int length);

    }  // namespace http
  } // namespace net
} // namespace sl

#endif // SL_NET_HTTP_FUNCTION_H
