/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: date.h,v 1.1 2006/10/28 16:08:25 cvsuser Exp $
 */

#ifndef SL_NET_HTTP_DATE_H
#define SL_NET_HTTP_DATE_H

#include <string>
#include <vector>

#if 0
 31/Jun/1999						Ūʥե
 31/Jun/1999:21:31:05				Ūʥե
 08-Jun-1999 01:15:01 GMT			줿RFC850 
 08-Jun-1999	  	 				줿 RFC850 HTTP 
 08-Jun-98 01:15:01 GMT				RFC850 
 08-Jun-98							ŤRFC850 HTTP 
 09 Jun 1999 22:23:32 GMT			HTTP 
 09 Jun 1999						Ƥ줿HTTP 
 12-01-98  31:52PM					Windows 'dir' 
 1999-01-31 01:15:01 -0100			ISO 8601 
 1999-01-31 01:15:01				ӡzoneˤϥץ
 1999-01-31							դΤ
 1999-01-31T01:15:01				ѥ졼ȤTȤ
 19990131							դΤ
 19990131T011501Z					ISO 8601 ѥ
 Jun  3  1999						Unix 'ls -l'
 Jun  3 21:31						Unix 'ls -l'
 Thu Jun  3 01:02:03 1999			ANSI C asctime() 
 Thu Jun  3 21:31:10 GMT 1999		ctime(3) 
 Tuesday, 08-Jun-1999 01:15:01 GMT	줿 RFC850 HTTP 
 Tuesday, 08-Jun-98 01:15:01 GMT	old RFC850 HTTP 
 Wed, 09 Jun 1999 21:22:23 GMT		HTTP 
#endif


namespace sl {
  namespace net {
    namespace http {

	class date {
		typedef std::vector<std::string>	slist_t;

	public :

		/**
		 *  s Ϥtime_t Ѵ֤ͤޤ.
		 * ޤǤ硢Ѵ˼Ԥ
		 * ͤ 0 Ȥʤޤ.
		 *
		 * @param	s	Http-Date դʸ
		 * @return	Ѵ time_t .
		 */
		static time_t string_to_time(const std::string &s);

		/**
		 *  t ϤʸѴ֤ͤޤ.
		 * ޤ t Ͻʤ϶ʸ֤ޤ.
		 *
		 * @param	clock	Ѵоݤ time_t .
		 * @return	 clock Ѵ std::string ʸ.
		 */
		static std::string time_to_string(time_t clock);

		/**
		 * ߻ʸȤ֤ޤ.
		 *
		 * @return	߻ʸ.
		 */
		static std::string current_time();

	private :
		/** Constructor. */
		date();
		static date& instance();
	
		slist_t		_format_list;
	};

    } // namespace http
  } // namespace net
} // namespace sl

#endif // SL_NET_HTTP_DATE_H
