/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: date.cpp,v 1.2 2008/03/01 03:28:13 cvsuser Exp $
 */

#include <time.h>

#include <sl/net/http/date.h>
using namespace sl::net::http;

#if defined(__CYGWIN__)
extern "C" {
	char* strptime(const char *, const char *, struct tm *);
}
#endif


time_t date::string_to_time(const std::string &s)
{
	std::string str(s);
	std::string::size_type pos;

	while ((pos = str.find("  ")) != std::string::npos ||
		   (pos = str.find("\t")) != std::string::npos)
		str.erase(pos, 1);

	slist_t::iterator i = instance()._format_list.begin();
	for (; i != instance()._format_list.end(); i++) {
		struct tm t;
		memset(&t, 0x00, sizeof(struct tm));

    	if (strptime(str.c_str(), i->c_str(), &t) != NULL) {
			if (t.tm_year == 0) {
				/* copy at retuning value */
				time_t dummy;
				::time(&dummy);
				struct tm now = *gmtime(&dummy);
				t.tm_year = now.tm_year;
			}
#ifdef CYGWIN
			return mktime(&t) + 9 * 60 * 60;
#else
			return timegm(&t);
#endif
		}
	}
	return 0;
}

std::string date::time_to_string(time_t clock)
{
	struct tm t = *gmtime(&clock);
	char time_string[64];

	int ret = strftime(time_string, 32, "%a, %d %b %Y %H:%M:%S GMT", &t);
	return ret != 0 ? time_string : "";
}

std::string date::current_time()
{
	return time_to_string(::time(NULL));
}

//
// private 
//

date::date()
{
	_format_list.push_back("%A, %d-%b-%Y %H:%M:%S GMT");
	_format_list.push_back("%A, %d-%b-%y %H:%M:%S GMT");
	_format_list.push_back("%Y%m%dT%H%M%S");
	_format_list.push_back("%Y-%m-%d %H:%M:%S");
	_format_list.push_back("%Y-%m-%dT%H:%M:%S");
	_format_list.push_back("%a %b %e %H:%M:%S %Y");
	_format_list.push_back("%a %b %e %H:%M:%S GMT %Y");
	_format_list.push_back("%a, %d %b %Y %H:%M:%S");
	_format_list.push_back("%b %e %H:%M");
	_format_list.push_back("%b %e %Y");
	_format_list.push_back("%d %b %Y %H:%M:%S GMT");
	_format_list.push_back("%d-%b-%Y %H:%M:%S GMT");
	_format_list.push_back("%d-%b-%y %H:%M:%S GMT");
	_format_list.push_back("%d/%b/%Y %H:%M:%S GMT");
	_format_list.push_back("%d/%b/%Y:%H:%M:%S GMT");
	_format_list.push_back("%m-%d-%y %H:%MPM");
}
		
date& date::instance()
{
	static date instance;
	return instance;
}
