/*
 * g++ test.cpp -I/usr/include/boost-1_33_1 \
 *				-I/usr/local/include \
 *				-L/usr/local/lib -L/usr/lib \
 *				-lnetwork -lboost_regex-gcc-mt-s
 */
#include <iostream>
using namespace std;

#include <msu/net/sip.h>
#include <msu/net/http.h>

sip::msg_ptr make_register()
{
	using namespace sip;

	msg_ptr reg(new reg_msg());

	request_header &req = header_cast<request_header>(reg);
	req.domain("192.168.1.1");

	via_header *v = new via_header();
	v->address("192.168.1.100");
	v->port("5060");
	v->attribute("branch", "abcdefg");

	fro_header *f = new fro_header();
	f->user("xxx");
	f->domain("192.168.1.1");
	f->attribute("tag", "123456789");

	to_header *t = new to_header();
	t->user("yyy");
	t->domain("192.168.1.1");

	call_id_header *i = new call_id_header();
	i->id("AAAAAAAAAAAAAAA");
	i->domain("192.168.1.100");

	contact_header *c = new contact_header();
	c->user("ABC");
	c->domain("192.168.1.100");
	c->attribute("expires", "3600");

	cseq_header *s = new cseq_header();
	s->seq_num(1);
	s->allow("REGISTER");

	max_forwards_header *m = new max_forwards_header();
	m->num("70");

	reg->header(header_ptr(v));
	reg->header(header_ptr(f));
	reg->header(header_ptr(t));
	reg->header(header_ptr(i));
	reg->header(header_ptr(c));
	reg->header(header_ptr(s));
	reg->header(header_ptr(m));

	return reg;
}


int main()
{
	sip::msg_ptr msg = make_register();
	cout << msg->string() << endl;

	return 0;
}
