/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: types.h,v 1.1 2006/10/28 16:07:00 cvsuser Exp $
 */

#ifndef SL_NET_AJP13_AJP13_TYPES_H
#define SL_NET_AJP13_AJP13_TYPES_H

#include <iostream>
#include <map>
#include <string>
#include <vector>


namespace sl {
  namespace net {
    namespace ajp13 {
	  namespace core {

		struct is_iequal {
			bool operator()(char l, char r) const
			{
				return tolower(l) == tolower(r);
			}
		};

		/**
		 * ʸʸ̤ӤԤʤؿǤ.
		 * إå°ʸӤԤʤ˻Ѥޤ.
		 * @param	l	ʸ.
		 * @param	r	ʸ.
		 * @return	true : Ʊ, false : ۤʤ.
		 */
		template <class Predicate>
		bool equals(const std::string &l, const std::string &r, Predicate p)
		{
			if (l.length() != r.length())
				return false;
	
			size_t length = l.length();
			for (size_t i = 0; i < length; i++) {
				if (!p(l[i], r[i]))
					return false;
			}
			return true;
		}
	}


	class ajp13_string;
	class ajp13_byte_array;

	/** ajp13ƤByte. */
	typedef char			Byte;

	/** ajp13ƤBoolean. */
	typedef unsigned char		Boolean;

	/** ajp13ƤInteger. */
	typedef unsigned short		Integer;

	/** ajp13ƤString. */
	typedef ajp13_string		String;

	/**
	 * ajp13ǤƤʤǤByte* ʷɽ뤿
	 * ޤ.
	 */
	typedef ajp13_byte_array	ByteArray;



	/**
	 * ajp13ǤStringɽ륯饹.
	 * ѥåȤꤵStringΥХ
	 * Ƭ2byteʸĹ2byteʹߤºݤΥǡȤʤꡢ
	 * '̥ʸ'ǽüƤޤ.
	 * ޤƬ2byteΥǡĹˤ'̥ʸ'ȴ
	 * ꤵޤ.
	 */
	class ajp13_string {
	public :

		/**
		 * Default Constructor.
		 *  0  ajp13_string ۤޤ.
		 */
		ajp13_string();

		/**
		 * Constructor.
		 * pƬ2byteǡĹȤƼp+2byteΰ֤
		 * ǡĹʬstd::string֥ȤȤ¸.
		 * @param	p	ajp13ѥåȤStringХƬؤΥݥ.
		 */
		ajp13_string(const char *p);

		/**
		 * std::string륳ԡ󥹥ȥ饯.
		 * ajp13_stringstd::stringؤηѴ򥵥ݡȤ뤿ᡢ
		 * std::stringΥԡ󥹥ȥ饯Τޤ.
		 * @param	r	std::stringԡоݤʸ.
		 */
		ajp13_string(const std::string &r);

		/**
		 * ʸԤޤ.
		 * @param	rhs	ʸǼ ajp13_string 饹
		 *			󥹥.
		 * @return	rhs ʸ ajp13_string λ.
		 */
		ajp13_string &operator=(const ajp13_string &rhs);

		/**
		 * ॢ򥵥ݡȤ뤿.
		 * @param	i	оݤΥǥå.
		 */
		char operator[](int i);

		/**
		 * 󥹥󥹤Υԡ˰ str ʸϢԤ
		 * Ϣ ajp13_string ֤ޤ.
		 * @param	str	Ϣʸ.
		 * @return	Ϣоݤ ajp13_string 󥹥.
		 */
		ajp13_string operator+(const std::string &str) const;

		/**
		 * std::stringؤηѴԤޤ.
		 */
		operator std::string() const;

		/**
		 * ʸƬΥɥ쥹֤ޤ.
		 * @return	ƬΥɥ쥹.
		 */
		const char *data() const;

		/**
		 * IntegerǡĹΥ + ʸĹ֤ޤ.
		 * @return	IntegerΥǡĹ
		 */
		Integer size() const;

		/**
		 * ǡĹޤޤʤʸΤߤĹ֤ޤ.
		 * @return	IntegerʸĹ
		 */
		Integer length() const;

		/**
		 * ݻƤstd::stringξ򥯥ꥢޤ.
		 */
		void clear();

	private :
		/**
		 * AJP/1.3 Ǥ String ζǤ֤ null 򼨤褦ʾ֤
		 * ߤʤΤǤȽѤΥե饰.
		 * AJP/1.3 إå remote_host ̤ 0xffff ꤵΤ
		 * attribute code 5(query_string) ǤĹ 0 ³ 0x00 
		 * ꤵƤѥ󤬤뤿ᡢ 0xffff  null ȸƤ
		 *  0 ǥǡ 0x00 Υǡ empty ȸƤ.
		 */
		bool			_null_flag;
		std::string		_string;

		friend bool operator<(const String &l, const String &r);
	};

	/**
	 * ajp13_string ФϢۥƥʤ.
	 */
	inline bool operator<(const String &l, const String &r)
	{
		return l._string < r._string;
	}

	/**
	 * Stringstd::ostream֥Ȥؤoperator<<򥵥ݡ.
	 * @param	os		ϥȥ꡼.
	 * @param	s		String֥.
	 */
	inline std::ostream &operator<<(std::ostream &os, const String &s)
	{
		std::string str(s.data(), s.length());
		return os << str;
	}


	/**
	 * ajp13ǤByte *ɽ륯饹.
	 * std::vector<> Ѥdecorator ѥȤƼƤꡢ
	 * operator+=() ࡼ˹Ԥ˺ޤ
	 */
	class ajp13_byte_array {
	public :

		/**
		 * Default Constructor.
		 *  0  ajp13_byte_array ۤޤ
		 */
		ajp13_byte_array();

		/**
		 * Constructor.
		 *  ptr λؤƤ ajp13_byte_array ۤޤ
		 * @param	ptr	ХǼƬΥɥ쥹.
		 * @param	size	ХΥ.
		 */
		ajp13_byte_array(const char *ptr, size_t size);

		/**
		 * Constructor.
		 *  ptr λؤƤ ajp13_byte_array ۤޤ
		 * @param	first	ɤ߹ХƬΥݥ.
		 * @param	last	ɤ߹ХΥݥ.
		 */
		ajp13_byte_array(Byte *first, Byte *last);

		/**
		 * Copy Constructor.
		 *  array ƱƤ ajp13_byte_array ۤޤ
		 * @param	array	ХǼajp13_byte_array֥.
		 */
		ajp13_byte_array(const ajp13_byte_array &array);

		/**
		 * Byte֥ȤХѴϢ뤷ޤ.
		 * @param	rhs	ХǼajp13_byte_array֥.
		 * @return	Ϣ array ֥ȤΥԡ֤ޤ.
		 */
		ajp13_byte_array operator+(const ajp13_byte_array &rhs) const; 

		/**
		 * Boolean֥ȤХѴϢ뤷ޤ.
		 * @param	b		Boolean֥.
		 * @return	Ϣ array ֥ȤΥԡ֤ޤ.
		 */
		ajp13_byte_array operator+(const Boolean b) const;

		/**
		 * Byte֥ȤХѴϢ뤷ޤ.
		 * @param	b		Byte֥.
		 * @return	Ϣ array ֥ȤΥԡ֤ޤ.
		 */
		ajp13_byte_array operator+(const Byte b) const;

		/**
		 * Integer֥ȤХѴϢ뤷ޤ.
		 * @param	i		Integer֥.
		 * @return	Ϣ array ֥ȤΥԡ֤ޤ.
		 */
		ajp13_byte_array operator+(const Integer i) const;

		/**
		 * String֥ȤХѴϢ뤷ޤ.
		 * @param	s		String֥.
		 * @return	Ϣ array ֥ȤΥԡ֤ޤ.
		 */
		ajp13_byte_array operator+(const String &s) const;

		/**
		 * Byte֥ȤХѴޤ.
		 * @param	rhs	ХǼajp13_byte_array֥.
		 * @return	 array ֥ȤλȤ֤ޤ.
		 */
		ajp13_byte_array &operator=(const ajp13_byte_array &rhs);

		/**
		 * Boolean֥ȤХѴޤ.
		 * @param	b		Boolean֥.
		 * @return	 array ֥ȤλȤ֤ޤ.
		 */
		ajp13_byte_array &operator=(const Boolean b);

		/**
		 * Byte֥ȤХѴޤ.
		 * @param	b		Byte֥.
		 * @return	 array ֥ȤλȤ֤ޤ.
		 */
		ajp13_byte_array &operator=(const Byte b);

		/**
		 * Integer֥ȤХѴޤ.
		 * @param	i		Integer֥.
		 * @return	 array ֥ȤλȤ֤ޤ.
		 */
		ajp13_byte_array &operator=(const Integer i);

		/**
		 * String֥ȤХѴޤ.
		 * @param	s		String֥.
		 * @return	 array ֥ȤλȤ֤ޤ.
		 */
		ajp13_byte_array &operator=(const String &s);

		/**
		 * ajp13_byte_array֥ȤϢ뤷ޤ.
		 * @param	rhs	ХǼajp13_byte_array֥.
		 * @return	Ϣ array ֥ȤλȤ֤ޤ.
		 */
		ajp13_byte_array &operator+=(const ajp13_byte_array &rhs);

		/**
		 * Boolean֥ȤХѴϢ뤷ޤ.
		 * @param	b		Boolean֥.
		 * @return	Ϣ array ֥ȤλȤ֤ޤ.
		 */
		ajp13_byte_array &operator+=(const Boolean b);

		/**
		 * Byte֥ȤХѴϢ뤷ޤ.
		 * @param	b		Byte֥.
		 * @return	Ϣ array ֥ȤλȤ֤ޤ.
		 */
		ajp13_byte_array &operator+=(const Byte b);

		/**
		 * Integer֥ȤХѴϢ뤷ޤ.
		 * @param	i		Integer֥.
		 * @return	Ϣ array ֥ȤλȤ֤ޤ.
		 */
		ajp13_byte_array &operator+=(const Integer i);

		/**
		 * String֥ȤХѴϢ뤷ޤ.
		 * @param	s		String֥.
		 * @return	Ϣ array ֥ȤλȤ֤ޤ.
		 */
		ajp13_byte_array &operator+=(const String &s);

		/**
		 * const char *ؤηѴ򥵥ݡȤޤ.
		 * ͤȤ֤ const char *  NULL üԤʤΤǡ
		 * дؿ size ˤäƥƲ.
		 */
		operator const Byte *() const;

		/**
		 * 󥹥󥹤ݻByteΥ֤ޤ.
		 * @return	ݻByteΥ.
		 */
		size_t size() const;

		/**
		 * 󥹥󥹤ݻByte򥯥ꥢޤ.
		 */
		void clear();

	private :
		std::vector<Byte>	_array;
	};


	/**
	 * ѥåȥإåꤵƤޥåޤ.
	 */
	class packet_magic {
	public :
		/**
		 * WEBФ饵֥åȥƥʤѥåȤ
		 * Ѥޥå.
		 */
		static const Integer	REQUEST;

		/**
		 * ֥åȥƥʤWEBФѥåȤ
		 * Ѥޥå.
		 */
		static const Integer	RESPONSE;

		/**
		 * ºݤ뤳Ȥ̵ޥåɤǤ뤬
		 * ʥѥåȤФ륳׵˻Ѥޤ.
		 */
		static const Integer	UNKNOWN;
	};


	/**
	 * ѥåȤΥץեåɤޤ.
	 * REQUES_BODY_CHUNK ڤ UNKNOWN ajp13ǤƤޤ󤬡
	 * ܥǥμ۾ʥѥåȤ
	 * ¾ΥѥåȼƱͤ˰뤿Ƥޤ.
	 */
	class prefix_code {

		typedef std::map<Byte, std::string>		byte_map_type;

	public :
		static const Byte	FORWARD_REQUEST;
		static const Byte	SEND_BODY_CHUNK;
		static const Byte	SEND_HEADERS;
		static const Byte	END_RESPONSE;
		static const Byte	GET_BODY_CHUNK;
		static const Byte	SHUTDOWN;

		static const Byte	REQUEST_BODY_CHUNK;
		static const Byte	UNKNOWN;

		/**
		 *  code ˸äѥåȥإåѤΥޥå֤ޤ.
		 * ⤷¸ߤʤ UNKNOWN ɤ֤ޤ.
		 * @param	code	prefix_code 줿.
		 */
		static Integer to_magic(Byte code)
		{
			if (code == FORWARD_REQUEST ||
			    code == SHUTDOWN ||
			    code == REQUEST_BODY_CHUNK)
			{
				return packet_magic::REQUEST;
			}

			if (code == SEND_BODY_CHUNK ||
			    code == SEND_HEADERS ||
			    code == GET_BODY_CHUNK ||
			    code == END_RESPONSE)
			{
				return packet_magic::RESPONSE;
			}
			return UNKNOWN;
		}

	private :

		static prefix_code &instance()
		{
			static prefix_code instance;
			return instance;
		}
	};


	/**
	 * ꥯȥѥå(forward_request_packet)ꤵ
	 * HTTP᥽åɥɤڤޤ.
	 */
	class method_code {

		typedef std::map<Byte, std::string>		byte_map_type;

	public :
		static const Byte	UNKNOWN;
		static const Byte	OPTIONS;
		static const Byte	GET;
		static const Byte	HEAD;
		static const Byte	POST;
		static const Byte	PUT;
		static const Byte	DELETE;
		static const Byte	TRACE;
		static const Byte	PROPFIND;
		static const Byte	PROPPATCH;
		static const Byte	MKCOL;
		static const Byte	COPY;
		static const Byte	MOVE;
		static const Byte	LOCK;
		static const Byte	UNLOCK;
		static const Byte	ACL;

		/**
		 *  s ˸äɤ֤ޤ.
		 * ⤷¸ߤʤ UNKNOWN ɤ֤ޤ.
		 * @param	s	std::stringΥ᥽åʸ.
		 * @return		Ѥߤ.
		 */
		static Byte to_code(const std::string &s)
		{
			byte_map_type::iterator i = instance()._map.begin();
			for (; i != instance()._map.end(); i++) {
				if (core::equals(i->second, s, core::is_iequal()))
					return i->first;
			}
			return UNKNOWN;
		}

		/**
		 *  code ˸äʸ֤ޤ.
		 * @param	code	Ѥߤ.
		 * @return	std::stringΥ᥽åʸ.
		 */
		static const std::string to_string(Byte code)
		{
			byte_map_type::iterator i = instance()._map.find(code);
			return i != instance()._map.end() ? i->second : "";
		}

		/**
		 *  code ˸äѤߤǤ뤫֤ޤ.
		 * @param	code	Byte֥.
		 * @return	code ѤǤtrue̵false.
		 */
		static bool find(Byte code)
		{
			return instance()._map.find(code) != instance()._map.end();
		}

	private :

		method_code();

		static method_code &instance()
		{
			static method_code instance;
			return instance;
		}

		byte_map_type		_map;
	};



	/**
	 * ꥯȥѥå(forward_request_packet)ꤵ
	 * HTTPꥯȥإåΥڤޤ.
	 */
	class req_header_code {

		typedef std::map<Integer, std::string>	integer_map_type;

	public :
		static const Integer	UNKNOWN;
		static const Integer	ACCEPT;
		static const Integer	ACCEPT_CHARSET;
		static const Integer	ACCEPT_ENCODING;
		static const Integer	ACCEPT_LANGUAGE;
		static const Integer	AUTHORIZATION;
		static const Integer	CONNECTION;
		static const Integer	CONTENT_TYPE;
		static const Integer	CONTENT_LENGTH;
		static const Integer	COOKIE;
		static const Integer	COOKIE2;
		static const Integer	HOST;
		static const Integer	PRAGMA;
		static const Integer	REFERER;
		static const Integer	USER_AGENT;

		/**
		 *  s ˸äɤ֤ޤ.
		 * ⤷¸ߤʤ UNKNOWN ɤ֤ޤ.
		 * @param	s	std::stringΥ᥽åʸ.
		 * @return		Ѥߤ.
		 */
		static Integer to_code(const std::string &s)
		{
			integer_map_type::iterator i = instance()._map.begin();
			for (; i != instance()._map.end(); i++) {
				if (core::equals(i->second, s, core::is_iequal()))
					return i->first;
			}
			return UNKNOWN;
		}

		/**
		 *  code ˸äʸ֤ޤ.
		 * @param	code	Ѥߤ.
		 * @return	std::stringΥ᥽åʸ.
		 */
		static const std::string to_string(Integer code)
		{
			integer_map_type::iterator i = instance()._map.find(code);
			return i != instance()._map.end() ? i->second : "";
		}

		/**
		 *  code ˸äѤߤǤ뤫֤ޤ.
		 * @param	code	Byte֥.
		 * @return	code ѤǤtrue̵false.
		 */
		static bool find(Integer code)
		{
			return instance()._map.find(code) != instance()._map.end();
		}

	private :

		req_header_code();

		static req_header_code &instance()
		{
			static req_header_code instance;
			return instance;
		}

		integer_map_type		_map;
	};


	/**
	 * 쥹ݥ󥹥إåѥå(send_headers_packet)ꤵ
	 * HTTP쥹ݥ󥹥إåΥڤޤ.
	 */
	class res_header_code {

		typedef std::map<Integer, std::string>	integer_map_type;

	public :
		static const Integer	UNKNOWN;
		static const Integer	CONTENT_TYPE;
		static const Integer	CONTENT_LANGAGE;
		static const Integer	CONTENT_LENGTH;
		static const Integer	DATE;
		static const Integer	LAST_MODIFIED;
		static const Integer	LOCATION;
		static const Integer	SET_COOKIE;
		static const Integer	SET_COOKIE2;
		static const Integer	SERVLET_ENGINE;
		static const Integer	STATUS;
		static const Integer	WWW_AUTHENTICATE;

		/**
		 *  s ˸äɤ֤ޤ.
		 * ⤷¸ߤʤ UNKNOWN ɤ֤ޤ.
		 * @param	s	std::stringΥ᥽åʸ.
		 * @return		Ѥߤ.
		 */
		static Integer to_code(const std::string &s)
		{
			integer_map_type::iterator i = instance()._map.begin();
			for (; i != instance()._map.end(); i++) {
				if (core::equals(i->second, s, core::is_iequal()))
					return i->first;
			}
			return UNKNOWN;
		}

		/**
		 *  code ˸äʸ֤ޤ.
		 * @param	code	Ѥߤ.
		 * @return	std::stringΥ᥽åʸ.
		 */
		static const std::string to_string(Integer code)
		{
			integer_map_type::iterator i = instance()._map.find(code);
			return i != instance()._map.end() ? i->second : "";
		}

		/**
		 *  code ˸äѤߤǤ뤫֤ޤ.
		 * @param	code	Byte֥.
		 * @return	code ѤǤtrue̵false.
		 */
		static bool find(Integer code)
		{
			return instance()._map.find(code) != instance()._map.end();
		}

	private :

		res_header_code();

		static res_header_code &instance()
		{
			static res_header_code instance;
			return instance;
		}

		integer_map_type		_map;
	};


	/**
	 * ꥯȥѥå(forward_request_packet)ꤵ
	 * °Υڤޤ.
	 */
	class attribute_code {

		typedef std::map<Byte, std::string>		byte_map_type;

	public :
		static const Byte	UNKNOWN;
		static const Byte	CONTEXT;
		static const Byte	SERVLET_PATH;
		static const Byte	REMOTE_USER;
		static const Byte	AUTH_TYPE;
		static const Byte	QUERY_STRING;
		static const Byte	JVM_ROUTE;
		static const Byte	SSL_CERT;
		static const Byte	SSL_CIPHER;
		static const Byte	SSL_SESSION;
		static const Byte	REQ_ATTRIBUTE;
		static const Byte	TERMINATOR;

		/**
		 *  s ˸äɤ֤ޤ.
		 * ⤷¸ߤʤ UNKNOWN ɤ֤ޤ.
		 * @param	s	std::stringΥ᥽åʸ.
		 * @return		Ѥߤ.
		 */
		static Byte to_code(const std::string &s)
		{
			byte_map_type::iterator i = instance()._map.begin();
			for (; i != instance()._map.end(); i++) {
				if (core::equals(i->second, s, core::is_iequal()))
					return i->first;
			}
			return UNKNOWN;
		}

		/**
		 *  code ˸äʸ֤ޤ.
		 * @param	code	Ѥߤ.
		 * @return	std::stringΥ᥽åʸ.
		 */
		static const std::string to_string(Byte code)
		{
			byte_map_type::iterator i = instance()._map.find(code);
			return i != instance()._map.end() ? i->second : "";
		}

		/**
		 *  code ˸äѤߤǤ뤫֤ޤ.
		 * @param	code	Byte֥.
		 * @return	code ѤǤtrue̵false.
		 */
		static bool find(Byte code)
		{
			return instance()._map.find(code) != instance()._map.end();
		}

	private :

		attribute_code();

		static attribute_code &instance()
		{
			static attribute_code instance;
			return instance;
		}

		byte_map_type		_map;
	};

    } // namespace ajp13
  } // namespace net
} // namespace sl

#endif // SL_NET_AJP13_AJP13_TYPES_H
