/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: types.cpp,v 1.2 2006/11/05 15:48:52 cvsuser Exp $
 */

#include <iostream>

#include <sl/net/ajp13/types.h>
#include <sl/net/ajp13/function.h>

namespace sl {
  namespace net {
    namespace ajp13 {

	//
	// ajp13_string 饹μ
	//

	//
	// Constructor/Destructor
	//

	ajp13_string::ajp13_string()
		: _null_flag(false)
	{ }

	ajp13_string::ajp13_string(const char *p)
		: _null_flag(false)
	{
		//
		// ξ 0xffff ΤߤƤ褦ʤΤ
		// ξϲ⤷ʤ.
		// ޤдؿ size ֤ͤ sizeof(Integer) ˤƤ.
		//
		if (static_cast<const unsigned char>(p[0]) == 0xff) {
			_null_flag = true;
			return;
		}		

		// ǡĹˤ'\0'ޤޤʤ+1'\0'ޤɤ߹.
		Integer length = (p[0] << 8) | (0x00ff & p[1]);
		if (length > 0)
			_string.assign(p + 2, length);
	}


	ajp13_string::ajp13_string(const std::string &r)
	{
		_string = r;
	}


	//
	// Member functions
	//

	ajp13_string &ajp13_string::operator=(const ajp13_string &r)
	{
		if (this == &r)
			return *this;

		_string.assign(r._string);
		_null_flag = r._null_flag;
		return *this;
	}

	char ajp13_string::operator[](int i)
	{
		if (i < 0 || i > length())
			return '\0';
		return _string[i];
	}

	ajp13_string ajp13_string::operator+(const std::string &s) const
	{
		return ajp13_string(_string + s);
	}

	ajp13_string::operator std::string() const
	{
		return _string;
	}

	const char *ajp13_string::data() const
	{
		return _string.data();
	}

	/**
	 *  null ĹޤʸĹ֤ޤ.
	 * @return	ajp13::Integer  ʸĹ.
	 */
	Integer ajp13_string::size() const
	{
		// String ξ 0xffff  2Byte ΤߤǤ뤿 2 ֤Ƥ.
                if (_string.length() > 0)
                    return sizeof(Integer) + _string.length() + 1;
                else
                    return sizeof(Integer);

		//return _null_flag == true ?
		//		sizeof(Integer) : sizeof(Integer) + _string.length() + 1;
	}

	/**
	 * AJP/1.3 ǻѤ褦 null ޤޤʤʸĹ֤ޤ.
	 * @return	ajp13::Integer  ʸĹ.
	 */
	Integer ajp13_string::length() const
	{
		return _string.length();
	}

	void ajp13_string::clear()
	{
		return _string.clear();
	}

	//
	// ajp13_byte_array 饹μ
	//
	//
	// Constructor/Destructor
	//

	ajp13_byte_array::ajp13_byte_array()
	{ }


	ajp13_byte_array::ajp13_byte_array(const char *p, size_t size)
	{ 
		_array = std::vector<Byte>(p, p + size);
	}


	ajp13_byte_array::ajp13_byte_array(Byte *first, Byte *last)
	{ 
		_array = std::vector<Byte>(first, last);
	}


	ajp13_byte_array::ajp13_byte_array(const ajp13_byte_array &rhs)
	{
		_array = rhs._array;
	}

	//
	// Member functions
	//

	// operator +

	ajp13_byte_array ajp13_byte_array::operator+(const Byte b) const
	{
		ajp13_byte_array array(&_array[0], _array.size());
		return array += b;
	}

	ajp13_byte_array ajp13_byte_array::operator+(const Boolean b) const
	{
		ajp13_byte_array array(&_array[0], _array.size());
		return array += static_cast<Byte>(b ? 0x01 : 0x00);
	}

	ajp13_byte_array ajp13_byte_array::operator+(const Integer i) const
	{
		ajp13_byte_array array(&_array[0], _array.size());
		array += static_cast<Byte>(i >> 8);
		array += static_cast<Byte>(0x00ff & i);
		return array;
	}

	ajp13_byte_array ajp13_byte_array::operator+(const ajp13_string &s) const
	{
		ajp13_byte_array array(&_array[0], _array.size());
		return array += s;
	}

	ajp13_byte_array ajp13_byte_array::operator+(const ajp13_byte_array &rhs) const
	{
		ajp13_byte_array array(&_array[0], _array.size());
		return array += rhs;
	}

	// operator =

	ajp13_byte_array &ajp13_byte_array::operator=(const Byte b)
	{
		_array.clear();
		return *this += b;
	}

	ajp13_byte_array &ajp13_byte_array::operator=(const Boolean b)
	{
		_array.clear();
		return *this += b;
	}

	ajp13_byte_array &ajp13_byte_array::operator=(const Integer i)
	{
		_array.clear();
		return *this += i;
	}

	ajp13_byte_array &ajp13_byte_array::operator=(const ajp13_string &s)
	{
		_array.clear();
		return *this += s;
	}

	ajp13_byte_array &ajp13_byte_array::operator=(const ajp13_byte_array &rhs)
	{
		_array.clear();
		return *this += rhs;
	}

	// operator +=

	ajp13_byte_array &ajp13_byte_array::operator+=(const Byte b)
	{
		_array.push_back(b);
		return *this;
	}

	ajp13_byte_array &ajp13_byte_array::operator+=(const Boolean b)
	{
		_array.push_back(b ? 0x01 : 0x00);
		return *this;
	}

	ajp13_byte_array &ajp13_byte_array::operator+=(const Integer i)
	{
		_array.push_back(i >> 8);
		_array.push_back(0x00ff & i);
		return *this;
	}

	ajp13_byte_array &ajp13_byte_array::operator+=(const ajp13_string &s)
	{
		*this += s.length();
		_array.insert(_array.end(), s.data(), s.data() + s.length());

		// s.data()s.length()ˤ'\0'ޤޤʤ­Ƥ.
		return *this += static_cast<Byte>(0x00);
	}

	ajp13_byte_array &ajp13_byte_array::operator+=(const ajp13_byte_array &rhs)
	{
		_array.insert(_array.end(), rhs._array.begin(), rhs._array.end());
		return *this;
	}

	ajp13_byte_array::operator const Byte *() const
	{
		return &_array[0];
	}

	size_t ajp13_byte_array::size() const
	{
		return _array.size();
	}

	void ajp13_byte_array::clear()
	{
		_array.clear();
	}


	//
	// packet_magic .
	//
	const Integer	packet_magic::REQUEST		= 0x1234;
	const Integer	packet_magic::RESPONSE		= 0x4142;
	const Integer	packet_magic::UNKNOWN		= 0xffff;


	//
	// prefix_code 
	//
	const Byte	prefix_code::FORWARD_REQUEST	= 0x02;
	const Byte	prefix_code::SEND_BODY_CHUNK	= 0x03;
	const Byte	prefix_code::SEND_HEADERS		= 0x04;
	const Byte	prefix_code::END_RESPONSE		= 0x05;
	const Byte	prefix_code::GET_BODY_CHUNK		= 0x06;
	const Byte	prefix_code::SHUTDOWN			= 0x07;

	const Byte	prefix_code::REQUEST_BODY_CHUNK	= 0xe0;
	const Byte	prefix_code::UNKNOWN			= 0xe1; 

	//
	// method_code ȥ󥹥ȥ饯
	//
	const Byte	method_code::UNKNOWN		= 0x00; 
	const Byte	method_code::OPTIONS		= 0x01;
	const Byte	method_code::GET			= 0x02;
	const Byte	method_code::HEAD			= 0x03;
	const Byte	method_code::POST			= 0x04;
	const Byte	method_code::PUT			= 0x05;
	const Byte	method_code::DELETE		= 0x06;
	const Byte	method_code::TRACE		= 0x07;
	const Byte	method_code::PROPFIND		= 0x08;
	const Byte	method_code::PROPPATCH	= 0x09;
	const Byte	method_code::MKCOL		= 0x0a;
	const Byte	method_code::COPY			= 0x0b;
	const Byte	method_code::MOVE			= 0x0c;
	const Byte	method_code::LOCK			= 0x0d;
	const Byte	method_code::UNLOCK		= 0x0e;
	const Byte	method_code::ACL			= 0x0f;

	method_code::method_code()
	{
		_map[OPTIONS]	= "OPTIONS";
		_map[GET]		= "GET";
		_map[HEAD]		= "HEAD";
		_map[POST]		= "POST";
		_map[PUT]		= "PUT";
		_map[DELETE]	= "DELETE";
		_map[TRACE]		= "TRACE";
		_map[PROPFIND]	= "PROPFIND";
		_map[PROPPATCH]	= "PROPPATCH";
		_map[MKCOL]		= "MKCOL";
		_map[COPY]		= "COPY";
		_map[MOVE]		= "MOVE";
		_map[LOCK]		= "LOCK";
		_map[UNLOCK]	= "UNLOCK";
		_map[ACL]		= "ACL";
	}


	//
	// req_header_code ȥ󥹥ȥ饯
	//
	const Integer	req_header_code::UNKNOWN			= 0xa000; 
	const Integer	req_header_code::ACCEPT			= 0xa001;
	const Integer	req_header_code::ACCEPT_CHARSET	= 0xa002;
	const Integer	req_header_code::ACCEPT_ENCODING	= 0xa003;
	const Integer	req_header_code::ACCEPT_LANGUAGE	= 0xa004;
	const Integer	req_header_code::AUTHORIZATION	= 0xa005;
	const Integer	req_header_code::CONNECTION		= 0xa006;
	const Integer	req_header_code::CONTENT_TYPE		= 0xa007;
	const Integer	req_header_code::CONTENT_LENGTH	= 0xa008;
	const Integer	req_header_code::COOKIE			= 0xa009;
	const Integer	req_header_code::COOKIE2			= 0xa00a;
	const Integer	req_header_code::HOST				= 0xa00b;
	const Integer	req_header_code::PRAGMA			= 0xa00c;
	const Integer	req_header_code::REFERER			= 0xa00d;
	const Integer	req_header_code::USER_AGENT		= 0xa00e;


	req_header_code::req_header_code()
	{
		_map[ACCEPT]			= "Accept";
		_map[ACCEPT_CHARSET]	= "Accept-Charset";
		_map[ACCEPT_ENCODING]	= "Accept-Encoding";
		_map[ACCEPT_LANGUAGE]	= "Accept-Language";
		_map[AUTHORIZATION]		= "Authorization";
		_map[CONNECTION]		= "Connection";
		_map[CONTENT_TYPE]		= "Content-Type";
		_map[CONTENT_LENGTH]	= "Content-Length";
		_map[COOKIE]			= "Cookie";
		_map[COOKIE2]			= "Cookie2";
		_map[HOST]				= "Host";
		_map[PRAGMA]			= "Pragma";
		_map[REFERER]			= "Referer";
		_map[USER_AGENT]		= "User-Agent";
	}


	//
	// res_header_code ȥ󥹥ȥ饯
	//
	const Integer	res_header_code::UNKNOWN			= 0xa000; 
	const Integer	res_header_code::CONTENT_TYPE		= 0xa001;
	const Integer	res_header_code::CONTENT_LANGAGE	= 0xa002;
	const Integer	res_header_code::CONTENT_LENGTH	= 0xa003;
	const Integer	res_header_code::DATE				= 0xa004;
	const Integer	res_header_code::LAST_MODIFIED	= 0xa005;
	const Integer	res_header_code::LOCATION			= 0xa006;
	const Integer	res_header_code::SET_COOKIE		= 0xa007;
	const Integer	res_header_code::SET_COOKIE2		= 0xa008;
	const Integer	res_header_code::SERVLET_ENGINE	= 0xa009;
	const Integer	res_header_code::STATUS			= 0xa00a;
	const Integer	res_header_code::WWW_AUTHENTICATE	= 0xa00b;

	res_header_code::res_header_code()
	{
		_map[CONTENT_TYPE]		= "Content-Type";
		_map[CONTENT_LANGAGE]	= "Content-Langage";
		_map[CONTENT_LENGTH]	= "Content-Length";
		_map[DATE]				= "Date";
		_map[LAST_MODIFIED]		= "Last-Modified";
		_map[LOCATION]			= "Location";
		_map[SET_COOKIE]		= "Set-Cookie";
		_map[SET_COOKIE2]		= "Set-Cookie2";
		_map[SERVLET_ENGINE]	= "Servlet-Engine";
		_map[STATUS]			= "Status";
		_map[WWW_AUTHENTICATE]	= "WWW-Authenticate";
	}


	//
	// attribute_code ȥ󥹥ȥ饯
	//
	const Byte	attribute_code::UNKNOWN		= 0x00; 
	const Byte	attribute_code::CONTEXT		= 0x01;
	const Byte	attribute_code::SERVLET_PATH	= 0x02;
	const Byte	attribute_code::REMOTE_USER	= 0x03;
	const Byte	attribute_code::AUTH_TYPE		= 0x04;
	const Byte	attribute_code::QUERY_STRING	= 0x05;
	const Byte	attribute_code::JVM_ROUTE		= 0x06;
	const Byte	attribute_code::SSL_CERT		= 0x07;
	const Byte	attribute_code::SSL_CIPHER		= 0x08;
	const Byte	attribute_code::SSL_SESSION	= 0x09;
	const Byte	attribute_code::REQ_ATTRIBUTE	= 0x0a;
	const Byte	attribute_code::TERMINATOR		= 0xff;

	attribute_code::attribute_code()
	{
		_map[CONTEXT]		= "context";
		_map[SERVLET_PATH]	= "servlet_path";
		_map[REMOTE_USER]	= "remote_user";
		_map[AUTH_TYPE]		= "auth_type";
		_map[QUERY_STRING]	= "query_string";
		_map[JVM_ROUTE]		= "jv_route";
		_map[SSL_CERT]		= "ssl_cert";
		_map[SSL_CIPHER]	= "ssl_cipher";
		_map[SSL_SESSION]	= "ssl_session";
		_map[REQ_ATTRIBUTE]	= "req_attribute";
		_map[TERMINATOR]	= "terminator";
	}

    } // namespace ajp13
  } // namespace net
} // namespace sl
