/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: send_headers_packet.h,v 1.7 2006/12/29 19:34:59 cvsuser Exp $
 */

#ifndef NET_AJP13_SEND_HEADERS_PACKET_H
#define NET_AJP13_SEND_HEADERS_PACKET_H

#include <map>
#include <string>

#include "packet.h"


namespace sl {
  namespace net {
    namespace ajp13 {

	/**
	 * ServletƥʤWebФˡơɵڤ
	 * ơå쥹ݥ󥹥إåݤ
	 * ѤѥåȤǤ.
	 * ơɵڤӥơåHTTPǻѤ˽

	 * 쥹ݥ󥹥إå res_header_code Ƥ륳ɤ
	 * 󥳡ɤ졢¾ΥإåʸȤޤ.
	 */
	class send_headers_packet : public packet {
	public :
		/** Constructor. */
		send_headers_packet();

		/**
		 * The member function of the base class is overwrited.
		 * @see		packet::prefix_code()
		 */
		Byte prefix_code() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		packet::operator=()
		 */
		virtual packet &operator=(const ByteArray &array)
			throw(ajp13_error);

		/**
		 * The member function of the base class is overwrited.
		 * @see		packet::operator ByteArray();
		 */
		operator ByteArray() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		packet::size()
		 */
		Integer size() const;


		/**
		 * HTTPꥯȤФ륹ơɤꤷޤ.
		 * @param	code	ơ.
		 * @note	ơɤ method_code 
		 *			ȤƲ.
		 */
		void status_code(Integer code);

		/**
		 * HTTPꥯȤФ륹ơåꤷޤ.
		 * @param	msg		ơå.
		 * @note	ơɤ method_code 
		 *			ȤƲ.
		 */
		void status_msg(const std::string &msg);

		/**
		 * ꤵƤ륹ơɤ֤ޤ.
		 * @return      ơ
		 * @note	ơɤ method_code 
		 *			ȤƲ.
		 */
		Integer status_code() const;

		/**
		 * ꤵƤ륹ơå֤ޤ.
		 * @return      ơå.
		 */
		std::string status_msg() const;

		/**
		 * 쥹ݥ󥹥إåꤷޤ.
		 * @param       code	res_header Ƥ
		 *			إåΥ.
		 * @param       value	إå.
		 * @throw       ajp13_error codevalueͤʾ
		 *		ꤲޤ.
		 */
		void header(Integer code, const std::string &value)
			throw(ajp13_error);

		/**
		 * 쥹ݥ󥹥إåꤷޤ.
		 * @param       name	إå̾.
		 * @param       value	إå.
		 * @throw       ajp13_error namevalueͤʾ
		 *		ꤲޤ.
		 */
		void header(const std::string& name, const std::string& value)
			throw(ajp13_error);


                void erase_header(const std::string& name);

		/**
		 *  name ǻꤵ줿̾ΥإåˤΥå
		 * ޤޤƤ뤫 bool ֤ͤޤ.
		 * @param	name	إå̾.
		 * @return		ꤵ줿إå̵ͭ.
		 */
		bool is_exist(const std::string &name) const;

		/**
		 * ݻƤƤξ˴ޤ.
		 */
		void clear();

		/**
		 *  os إѥåȤΥפϤޤ. debugѤǤ.
		 * @param	os	ϥȥ꡼४֥.
		 */
		void dump(std::ostream &os);

	private :
		void parse_headers(const Byte *&p);

		Integer		_http_status_code;
		String		_http_status_msg;
		Integer		_nu_headers;

		std::map<Integer, String>	_headers;
		std::map<String, String>	_other_headers;
	};

    } // namespace ajp13
  } // namespace net
} // namespace sl

#endif // NET_AJP13_SEND_HEADERS_PACKET_H
