/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: send_body_chunk_packet.h,v 1.4 2006/12/29 19:34:59 cvsuser Exp $
 */

#ifndef SL_NET_AJP13_SEND_BODY_CHUNK_PACKET_H
#define SL_NET_AJP13_SEND_BODY_CHUNK_PACKET_H

#include "packet.h"

namespace sl {
  namespace net {
    namespace ajp13 {

	/**
	 * ServletƥʤWEBС쥹ݥ󥹤
	 * ܥǥʬžݤ˻ѤѥåȤǤ.
	 * ̾ΥѥåȤꤵ줿ǡľܥ饤(֥饦)
	 * Ϥޤ.
	 */
	class send_body_chunk_packet : public packet {
	public :

		send_body_chunk_packet();

		Byte prefix_code() const;

		virtual packet &operator=(const ByteArray &array)
			throw(ajp13_error);

		operator ByteArray() const;

		Integer size() const;

		/**
		 *  s ܥǥ󥯤Ȥꤷޤ.
		 * ̾HTMLΥƥꤵޤ.
		 * @param	s	std::stringΥƥĥǡ.
		 */
		void body_chunk(const std::string &s)
		{
			_body_length = s.length();
			_body_chunk = ByteArray(s.data(), s.length());
		}

		/**
		 * ܥǥ󥯤std::stringѴ֤ޤ.
		 * @return	std::stringΥܥǥ.
		 */
		std::string body_chunk() const
		{
			return std::string(&_body_chunk[0], _body_length);
		}

		/**
		 * ܥǥ󥯤simasu
		 *
		 */
		void clear()
		{
			_body_length = 0;
			_body_chunk.clear();
		}

	private :
		ByteArray	_body_chunk;
		Integer		_body_length;
	};

    } // namespace ajp13
  } // namespace net
} // namespace sl

#endif // SL_NET_AJP13_SEND_BODY_CHUNK_PACKET_H
