/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: send_body_chunk_packet.cpp,v 1.5 2006/12/29 19:34:59 cvsuser Exp $
 */

#include <sl/net/ajp13/ajp13_error.h>
#include <sl/net/ajp13/function.h>
#include <sl/net/ajp13/send_body_chunk_packet.h>
using namespace sl::net::ajp13;


// Constructor/Destructor
send_body_chunk_packet::send_body_chunk_packet()
	: _body_length(0)
{ }


//
// Member functions
//
Byte send_body_chunk_packet::prefix_code() const
{
	return prefix_code::SEND_BODY_CHUNK;
}


packet &send_body_chunk_packet::operator=(const ByteArray &array)
	throw(ajp13_error)
{
	const Byte *p = array;

	if (*p != this->prefix_code())
		throw std::invalid_argument("invalid prefix code");
	++p;	// skip prefix_code

    _body_length = get_integer(p);	p += sizeof(Integer);
    _body_chunk  = ByteArray(p, _body_length);

	return *this;
}


send_body_chunk_packet::operator ByteArray() const
{
	ByteArray	array;
	array += prefix_code();
	array += _body_length;
	array += _body_chunk;
	array += static_cast<Byte>(0x00);

	return array;
}


Integer send_body_chunk_packet::size() const
{
	Integer s = 0;
	s += sizeof(Byte);					// Byte		_prefix_code;
	s += sizeof(Integer);				// Integer	_body_length;
	s += sizeof(Byte) * _body_length;	// 			_body;
	s += sizeof(Byte);					// end of Null

	return s;
}
