/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: request_body_chunk_packet.h,v 1.4 2006/10/28 16:05:57 cvsuser Exp $
 */

#ifndef NET_AJP13_REQUEST_BODY_CHUNK_PACKET_H
#define NET_AJP13_REQUEST_BODY_CHUNK_PACKET_H

#include "packet.h"

namespace sl {
  namespace net {
    namespace ajp13 {

	/**
	 * WEBСꥯȥܥǥΥǡ
	 * 뤿Υ饹Ǥ.
	 *
	 * @note	packetѾƤޤ
	 *		ºݤajp13줿ѥåȤǤϤޤ.
	 *		get_body_chunk_packet WEBСإꥯȤǡ
	 *		ǼƤ˺ޤ.
	 *		WEBСܥǥϡ
	 *		إåޥå/ѥåĹ/ȤʤäƤꡢ
	 *		ajp13::String ƱͤƬ2ХȤ³Х
	 *		󥯥ǡȤʤäƤޤ.
	 *
	 *		衢ܥǥѤΥץեåɤ¸ߤޤ󤬡
	 *		prefix_code()  prefix_code::REQUEST_BODY_CHUNK_PACKET
	 *		֤ޤ.
	 */
	class request_body_chunk_packet : public packet {
	public :

		Byte prefix_code() const;

		virtual packet &operator=(const ByteArray &array)
			throw(ajp13_error);

		operator ByteArray() const;

		Integer size() const;

		/**
		 * body_chunkΥǡstd::stringѴ֤ޤ.
		 * @return		std::string body_chunkǡ.
		 */
		std::string body() const;

		/**
		 * body_chunkΥǡstd::stringѴ֤ޤ.
		 * @param	r	std::string ꥯȤΥƥ.
		 */
		void body(const std::string &r);

		/**
		 * body_chunkΥǡޤ.
		 */
		void clear();

	private :
		ByteArray		_body_chunk;
		Integer			_body_length;
	};

    } // namespace ajp13
  } // namespace net
} // namespace sl

#endif // NET_AJP13_REQUEST_BODY_CHUNK_PACKET_H
