/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: packet_set.h,v 1.1 2006/10/28 16:07:00 cvsuser Exp $
 */

#ifndef NET_AJP13_AJP13_PACKET_SET_H
#define NET_AJP13_AJP13_PACKET_SET_H

#include <iostream>
#include <string>

#include "ajp13_error.h"
#include "forward_request_packet.h"
#include "request_body_chunk_packet.h"
#include "send_headers_packet.h"
#include "send_body_chunk_packet.h"
#include "end_response_packet.h"


namespace sl {
  namespace net {
    namespace ajp13 {

	/**
	 * std::iostream ȤΥ쥹ư륯饹.
	 *
	 * forward_request_packet  request_body_chunk_packet ˻
	 * std::iostream ƥФŸ
	 * ޤ std::ostream ؤΥХȷǤνϤԤʤޤ.
	 */
	class request_packets {
	public :
		/**
		 * Default Constructor.
		 *  ѥåȤݻ request_packets ۤޤ.
		 */
		request_packets();

		/**
		 * Constructor.
		 *  in Хȥǡɤ߹ߤԤʤ
		 * forward_request_packet ڤӡ request_body_chunk_packet 
		 * ۤޤ.
		 *
		 * @param	in	Хȥǡɤ߹.
		 * @note	request_body_chunk_packet ϥꥯȤ
		 *		ܥǥ㥯󥯤¸ߤ˺ޤ.
		 */
		request_packets(std::istream &in);

		/**
		 * Destructor.
		 */
		~request_packets();

		/**
		 * ѥåȤꥯURIɤ߽Фޤ.
		 *
		 * @return	std::string ꥯURI.
		 */
		const std::string req_uri() const;

		/**
		 *
		 */
		void clear();

	private :

		forward_request_packet 		_request;
		request_body_chunk_packet	_body;

		friend	void read_packets(int fd, request_packets &p)
				throw (ajp13_error);
	
		friend	std::istream &read_packets(std::istream &i, request_packets &p)
				throw (ajp13_error);

		friend	void write_packets(int fd, request_packets &p)
				throw (ajp13_error);

		friend	std::ostream &write_packets(std::ostream &o, request_packets &p)
				throw (ajp13_error);
	};


	void read_packets(int fd, request_packets &p)
		throw (ajp13_error);

	std::istream &read_packets(std::istream &i, request_packets &p)
		throw (ajp13_error);

	void write_packets(int fd, request_packets &p)
		throw (ajp13_error);

	std::ostream &write_packets(std::istream &o, request_packets &p)
		throw (ajp13_error);



	/**
	 * std::iostream ȤΥ쥹ư륯饹.
	 */
	class response_packets {
	public :
		response_packets();
		response_packets(std::istream &in);

		void set_packet(send_headers_packet &packet)
		{
			_response = packet;
		}

		void set_packet(send_body_chunk_packet &packet)
		{
			_body = packet;
		}

		void set_packet(end_response_packet &packet)
		{
			_end = packet;
		}

		/**
		 *
		 */
		void clear();

	private :
		send_headers_packet 	_response;
		send_body_chunk_packet 	_body;
		end_response_packet 	_end;

		friend	void read_packets(int fd, response_packets &p)
				throw (ajp13_error);
	
		friend	std::istream &read_packets(std::istream &i, response_packets &p)
				throw (ajp13_error);

		friend	void write_packets(int fd, response_packets &p)
				throw (ajp13_error);

		friend	std::ostream &write_packets(std::ostream &o,response_packets &p)
				throw (ajp13_error);
	};

	void read_packets(int fd, response_packets &p)
		throw (ajp13_error);

	std::istream &read_packets(std::istream &i, response_packets &p)
		throw (ajp13_error);

	void write_packets(int fd, response_packets &p)
		throw (ajp13_error);

	std::ostream &write_packets(std::istream &o, response_packets &p)
		throw (ajp13_error);

    } // namespace ajp13
  } // namespace net
} // namespace sl

#endif // NET_AJP13_AJP13_PACKET_SET_H
