/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: packet_set.cpp,v 1.1 2006/10/28 16:07:00 cvsuser Exp $
 */

#include <sl/net/ajp13/end_response_packet.h>
#include <sl/net/ajp13/forward_request_packet.h>
#include <sl/net/ajp13/function.h>
#include <sl/net/ajp13/interface.h>
#include <sl/net/ajp13/packet_set.h>
#include <sl/net/ajp13/request_body_chunk_packet.h>
#include <sl/net/ajp13/send_body_chunk_packet.h>
#include <sl/net/ajp13/send_headers_packet.h>
using namespace sl::net::ajp13;


//
// Constructor/Destructor
//

request_packets::request_packets()
{ }


request_packets::request_packets(std::istream &is)
{
	try {
		_request.clear();
		ajp13::read_packet(is, _request);

		if (_request.content_length() > 0)
			ajp13::read_packet(is, _body);
	} catch(ajp13_error &e) {
		std::cerr << e.what() << std::endl;
	}
}


request_packets::~request_packets()
{ }


//
// Operators.
//



//
// Member functions.
//

const std::string request_packets::req_uri() const
{
	return _request.req_uri();
}


void request_packets::clear()
{
	_request.clear();
	_body.clear();
}

 
//
// friend functions.
//
namespace sl {
  namespace net {
    namespace ajp13 {

	std::istream &read_packets(std::istream &is, request_packets &p)
		throw (ajp13_error)
	{
		request_packets temp;
		try {
			read_packet(is, temp._request);

			if (temp._request.content_length())
				read_packet(is, temp._body);
		} catch(ajp13_error &e) {
			throw e;
		}

		p = temp;
		return is;
	}

	void read_packets(int fd, request_packets &p)
		throw (ajp13_error)
	{
		request_packets temp;
		try {
			read_packet(fd, temp._request);

			if (temp._request.content_length())
				read_packet(fd, temp._body);
		} catch(ajp13_error &e) {
			throw e;
		}

		p = temp;
	}

	std::ostream &write_packets(std::ostream &os, request_packets &p)
		throw (ajp13_error)
	{
		write_packet(os, p._request);
		write_packet(os, p._body);

		return os;
	}

	void write_packets(int fd, request_packets &p)
		throw (ajp13_error)
	{
		write_packet(fd, p._request);
		write_packet(fd, p._body);
	}

} } // namespace net::ajp13

//
// Constructor/Destructor
//

response_packets::response_packets()
{ }


response_packets::response_packets(std::istream &is)
{
	read_packet(is, _response);
	read_packet(is, _body);
	read_packet(is, _end);
}



//
// Operators.
//



//
// Member functions.
//

void response_packets::clear()
{
	_response.clear();
	_body.clear();
	_end.clear();
}


//
// friend funstions.
//

namespace net { namespace ajp13 {

	std::istream &read_packets(std::istream &is, response_packets &p)
		throw (ajp13_error)
	{
		read_packet(is, p._response);
		read_packet(is, p._body);
		read_packet(is, p._end);
		return is;
	}

	void read_packets(int fd, response_packets &p)
		throw (ajp13_error)
	{
		read_packet(fd, p._response);
		read_packet(fd, p._body);
		read_packet(fd, p._end);
	}

	std::ostream &write_packets(std::ostream &os, response_packets &p)
		throw (ajp13_error)
	{
		write_packet(os, p._response);
		write_packet(os, p._body);
		write_packet(os, p._end);
		
		return os;
	}

	void write_packets(int fd, response_packets &p)
		throw (ajp13_error)
	{
		write_packet(fd, p._response);
		write_packet(fd, p._body);
		write_packet(fd, p._end);
	}

    }  // namespace ajp13
  }  // namespace net
}  // namespace sl
