/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: packet.h,v 1.1 2006/10/28 16:07:00 cvsuser Exp $
 */

#ifndef SL_NET_AJP13_PACKET_H
#define SL_NET_AJP13_PACKET_H

#include <sl/net/ajp13/types.h>
#include <sl/net/ajp13/ajp13_error.h>


namespace sl {
  namespace net {
    namespace ajp13 {

	/**
	 * ajp13ѤΥѥåȤɽ٤β۴쥯饹.
	 * ajp13γƥѥåȤϥФν貾۴ؿޤ.
	 *
	 * @note	ѥåȤWEBСȥƥʤХȤǤꡢ
	 *		Ƭ2byteإåޥåȤWEBС饳ƥʤؤ
	 *		ѥå 0x1234 ꤵ졢
	 *		ƥʤWEBСؤΥѥå 0x4142 ꤵޤ.
	 *		³2byteǥѥåΤΥݻޤ.
	 *		packet(ϡ饹)ϥޥå/ѥåĹ
	 *		Ƭ4byteƥѥåȸ̤ξǼޤ.
	 */
	class packet {
	public :
		/** Destructor. */
		virtual ~packet() { }

		/**
		 * ѥåȤΥץեå֤ޤ.
		 * @return	ByteΥץեå.
		 */
		virtual Byte prefix_code() const=0;

		/**
		 * ByteArrayѥåȤιۤԤޤ.
		 * @param	array	ǡꤵ줿ByteArray֥.
		 */
		virtual packet &operator=(const ByteArray &array)
			throw(ajp13_error)=0;

		/**
		 * ByteArrayؤηѴ򥵥ݡȤޤ.
		 */
		virtual operator ByteArray() const=0;

		/**
		 * ѥåȤByteArrayȤƤΥХȿ֤ޤ.
		 * @return	IntegerΥХȿ.
		 */
		virtual Integer size() const=0;
	};

    } // namespace ajp13
  } // namespace net
} // namespace sl

#endif // SL_NET_AJP13_PACKET_H
