/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: interface.h,v 1.1 2006/10/28 16:07:00 cvsuser Exp $
 */

#ifndef SL_NET_AJP13_INTERFACE_H
#define SL_NET_AJP13_INTERFACE_H

#include <iostream>
#include <sl/net/ajp13/ajp13_error.h>

namespace sl {
  namespace net {
    namespace ajp13 {

	class packet;

	/**
	 * std::istreamϤ򥵥ݡ.
	 * @param	in	std::istreamѾϥȥ꡼.
	 * @param	p	packetѾѥåȥ֥.
	 * @throw		ɤ߹ߥ顼.
	 */
	std::istream &operator>>(std::istream &in, packet &p)
		throw(ajp13_error);

	/**
	 * std::ostreamؤνϤ򥵥ݡ.
	 * @param	out	std::ostreamѾϥȥ꡼.
	 * @param	p	packetѾѥåȥ֥.
	 * @throw		Ͻ񤭹ߥ顼.
	 */
	std::ostream &operator<<(std::ostream &out, const packet &p)
		throw(ajp13_error);

    } // namespace ajp13
  } // namespace net
} // namespace sl

#endif // SL_NET_AJP13_INTERFACE_H
