/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: get_body_chunk_packet.h,v 1.3 2006/10/28 16:05:57 cvsuser Exp $
 */

#ifndef NET_AJP13_GET_BODY_CHUNK_PACKET_H
#define NET_AJP13_GET_BODY_CHUNK_PACKET_H

#include "packet.h"

namespace sl {
  namespace net {
    namespace ajp13 {

	/**
	 * WEBСإꥯȤ׵᤹ѥåȤǤ.
	 *
	 * WEBСΥꥯȤɤ߹ޤƤʤˡ
	 * ׵᤹륵(request_length)ꤷWEBФޤ.
	 * ̾POST᥽åɤContent-Length1ʾǤäꡢ
	 * ѥåȤΥإå˵Ҥ줿ѥåȥ
	 * read 褿ʤ˻Ѥޤ.
	 * WEBС٤Ķ׵᤹륵ꤹȡ
	 * ĶʬNullꤵ줿ХWEBСޤ.
	 */

	class get_body_chunk_packet : public packet {
	public :
		get_body_chunk_packet() : _request_length(0) { }

		Byte prefix_code() const;

		virtual packet &operator=(const ByteArray &array)
			throw(ajp13_error);

		operator ByteArray() const;

		Integer size() const;

		/**
		 * WEBС׵᤹륵 request_length ꤷޤ.
		 * @param	len		ꤹInteger.
		 */
		void request_length(Integer len)
		{
			_request_length = len;
		}

		/**
		 * ꤵƤWEBС
		 * ׵᤹륵 request_length ޤ.
		 * @return	ꤵƤInteger.
		 */
		Integer request_length() const
		{
			return _request_length;
		}

	private :
		Integer		_request_length;
	};

    } // namespace ajp13
  } // namespace net
} // namespace sl

#endif // NET_AJP13_GET_BODY_CHUNK_PACKET_H
