/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: function.cpp,v 1.1 2006/10/28 16:07:00 cvsuser Exp $
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <sstream>

#include <sl/net/ajp13/function.h>

namespace sl {
  namespace net {
    namespace ajp13 {

	void read_packet(int fd, packet& packet)
		throw(ajp13_error)
	{
		char		buf[2] = {'\0','\0'};
		Integer		magic;
		Integer		length;

		for (;;) {
			fd_set  fds;
			FD_ZERO(&fds);
			FD_SET(fd, &fds);

			struct timeval t;
			t.tv_sec = 1;
			t.tv_usec= 0;

			if (::select(FD_SETSIZE, &fds, NULL, NULL, &t) < 0)
				throw ajp13_error(
								"select error occurred while executing it.");

			if (FD_ISSET(fd, &fds))
				break;
		}

		::read(fd, buf, 2);
		magic = (buf[0] << 8) | (0x00ff & buf[1]);

		if ((magic != packet_magic::REQUEST) &&
			(magic != packet_magic::RESPONSE)) {
			std::stringstream ss;
			ss << "0x" << buf[0] << "0x" << buf[1];
			throw ajp13_error(
					std::string("Invalid packet header magic :") + ss.str());
		}

		for (;;) {
			fd_set  fds;
			FD_ZERO(&fds);
			FD_SET(fd, &fds);

			struct timeval t;
			t.tv_sec = 1;
			t.tv_usec= 0;

			if (::select(FD_SETSIZE, &fds, NULL, NULL, &t) < 0)
				throw ajp13_error(
								"select error occurred while executing it.");

			if (FD_ISSET(fd, &fds))
				break;
		}

		::read(fd, buf, 2);
		length = (buf[0] << 8) | (0x00ff & buf[1]);

		char*	buffer = new char[length];
		::read(fd, buffer, length);

		ByteArray	array(buffer, buffer + length);

		// Х󤫤ѥåȤۤޤ
		packet = array;

		delete buffer;
	}


	void read_packet(std::istream& in, packet& packet)
		throw(ajp13_error)
	{
		char		buf[2] = {'\0','\0'};
		Integer		magic;
		Integer		length;

		in.read(buf, 2);
		magic = (buf[0] << 8) | (0x00ff & buf[1]);

		if ((magic != packet_magic::REQUEST) &&
			(magic != packet_magic::RESPONSE)) {
			std::stringstream ss;
			ss << "0x" << buf[0] << "0x" << buf[1];
			throw ajp13_error(
					std::string("Invalid packet header magic :") + ss.str());
		}

		in.read(buf, 2);
		length = (buf[0] << 8) | (0x00ff & buf[1]);

		char* buffer = new char[length];
		in.read(buffer, length);

		ByteArray	array(buffer, buffer + length);

		// Х󤫤ѥåȤۤޤ
		packet = array;

		delete buffer;
	}


	void write_packet(int fd, const packet& packet)
		throw(ajp13_error)
	{
		// ץեåɤˤäƥإåޥå
		Integer	magic = prefix_code::to_magic(packet.prefix_code());

		// إåpacket򤯤դޤ
		ByteArray	bytes;
		bytes += magic;
		bytes += packet.size();
		bytes += ByteArray(packet);

		::send(fd, &bytes[0], bytes.size(), 0);
	}


	void write_packet(std::ostream& out, const packet& packet)
		throw(ajp13_error)
	{
		// ץեåɤˤäƥإåޥå
		Integer	magic = prefix_code::to_magic(packet.prefix_code());

		// إåpacket򤯤դޤ
		ByteArray	bytes;
		bytes += magic;
		bytes += packet.size();
		bytes += ByteArray(packet);

		out.write(&bytes[0], bytes.size());
	}

    } // namespace ajp13
  } // namespace net
} // namespace sl
