/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: forward_request_packet.h,v 1.7 2006/10/28 16:05:57 cvsuser Exp $
 */

#ifndef SL_NET_AJP13_FORWARD_REQUEST_PACKET_H
#define SL_NET_AJP13_FORWARD_REQUEST_PACKET_H

#include <iostream>
#include <string>
#include <map>

#include "packet.h"

namespace sl {
  namespace net {
    namespace ajp13 {

	/**
	 * WEBСꥯȽ
	 * ѤΥѥåȤǼ뤿Υ饹Ǥ.
	 *
	 * POST᥽åΥƥ
	 * ̥ѥå( net::ajp13::request_body_chunk_packet )ޤ.
	 */
	class forward_request_packet : public packet {
	public :

		/**
		 * Default Constructor.
		 * @note	ǥեȥ󥹥ȥ饯ˤäƺ줿
		 *		ѥåȤϤΤޤޤξ֤Ǥǡ
		 *		礬¸ߤΤǡɬдؿˤä
		 *		ƥǡꤷΤ˳Ʋ.
		 */
		forward_request_packet();

		/**
		 * The member function of the base class is overwrited.
		 * @see		packet::prefix_code.
		 */
		Byte prefix_code() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		packet::operator=()
		 */
		virtual packet &operator=(const ByteArray &array)
			throw(ajp13_error);

		/**
		 * The member function of the base class is overwrited.
		 * @see		packet::operator ByteArray()
		 */
		operator ByteArray() const;

		/**
		 * The member function of the base class is overwrited.
		 * @see		packet::size()
		 */
		Integer size() const;

		/**
		 * ѥåȥǡHTTPꥯȤ
		 * ץ졼ƥȤѴ֤ޤ.
		 * @return	std::stringHTTPꥯȥإå.
		 */
		std::string text() const;

		/**
		 *  os إѥåȤΥפϤޤ. debugѤǤ.
		 * @param	os	ϥȥ꡼४֥.
		 */
		void dump(std::ostream &os);

		/**
		 * ᥽åɤꤷޤ.
		 * @param	s	std::string᥽åʸ.
		 */
		void method(const std::string& s) throw(ajp13_error);

		/**
		 * ᥽åɤ֤ޤ.
		 * @return		std::string᥽åʸ.
		 */
		std::string method() const;

		/**
		 * ץȥꤷޤ.
		 * @param	s	std::stringץȥʸ.
		 */
		void protocol(const std::string& s);

		/**
		 * ץȥ֤ޤ.
		 * @return		std::stringץȥʸ.
		 */
		std::string protocol() const;

		/**
		 * ꥯURIꤷޤ.
		 * @param	s	std::stringꥯURIʸ.
		 */
		void req_uri(const std::string& s);

		/**
		 * ꥯURI֤ޤ.
		 * @return		std::stringꥯURIʸ.
		 */
		std::string req_uri() const;

		/**
		 *  k ̾İ s إåꤷޤ.
		 * ⤷k AJP1.3Υ󥳡ɲǽʾϥ󥳡ɤ줿
		 * إåɤȤݻޤ.
		 * @param	k	std::stringإå̾.
		 * @param	s	std::stringإå.
		 */
		void header(const std::string& k, const std::string& s);

		/**
		 *  s ̾ĥإå֤ͤޤ.
		 * @return		std::stringꥯURIʸ.
		 */
		std::string header(const std::string& s) const;

		/**
		 *  k ̾İ s إåꤷޤ.
		 * ⤷k AJP1.3Υ󥳡ɲǽʾϥ󥳡ɤ줿
		 * °ɤȤݻޤ.
		 * @param	k	std::stringإå̾.
		 * @param	s	std::stringإå.
		 */
		void attribute(const std::string& k, const std::string& s);

		/**
		 * SSL̵ͭ.
		 * @param	flag	饤ȤSSL̵ͭꤷޤ.
		 * @note	̾WEBФѥåȼSSL̵ͭ
		 *		ꤵޤ˥ѥåȤơ
		 *		ǡ򥳥ԡݤ˻Ѥ뤿.
		 */
		void is_ssl(bool flag);

		/**
		 * SSL̵ͭ.
		 * @return	饤ȤSSL̵ͭ.
		 */
		bool is_ssl() const;

		/**
		 * ѥåȤФ remote_addr ꤷޤ.
		 * @param	s	⡼ȥɥ쥹.
		 */
		void remote_addr(const String& s);

		/**
		 * ѥåȤФ remote_host ꤷޤ.
		 * @param	s	⡼ȥۥ̾.
		 */
		void remote_host(const String& s);

		/**
		 * ѥåȤФ server_name ꤷޤ.
		 * @param	s	̾.
		 */
		void server_name(const String& s);

		/**
		 * ѥåȤФ server_addr ꤷޤ.
		 * @param	s	Хݡֹ.
		 */
		void server_port(Integer i);

		/**
		 * ѥåȤ ⡼ȤΥɥ쥹ޤ.
		 * @return	remote_addr.
		 */
		String remote_addr() const;

		/**
		 * ѥåȤ ⡼ȤΥۥ̾ޤ.
		 * @return	remote_host.
		 */
		String remote_host() const;

		/**
		 * ѥåȤ ̾ޤ.
		 * @return	String  ̾.
		 */
		String server_name() const;

		/**
		 * ѥåȤ ФΥݡֹޤ.
		 * @return	Integer  port ֹ.
		 */
		Integer server_port() const;

		/**
		 * ꥯȥإåꤵƤContent-Lengthͤ
		 * ֤ޤ.
		 * ѥåȤΥꥯȥإåContent-Length򸡺
		 * ¸ߤƤϤꤵƤ֤ͤ
		 * ¸ߤƤʤ 0 ֤ޤ.
		 *
		 * @return	IntegerContent-Length.
		 */
		Integer content_length() const;

		/**
		 * ѥåȤλƤΥإå̾ͤΥޥåפȤ֤ޤ.
		 *
		 * @return		إå̾ͤΥޥå.
		 */
		std::multimap<std::string, std::string> headers() const;

		/**
		 * ѥåȤλƤ°̾ͤΥޥåפȤ֤ޤ.
		 *
		 * @return		°̾ͤΥޥå.
		 */
		std::map<std::string, std::string> attributes() const;

		/**
		 * ݻƤƤξ˴ޤ.
		 */
		void clear();

	private :

		void parse_headers(const Byte * &p);
		bool parse_attributes(const Byte * &p);

		Byte		_method;
		String		_protocol;
		String		_req_uri;
		String		_remote_addr;
		String		_remote_host;
		String		_server_name;
		Integer		_server_port;
		Boolean		_is_ssl;
		Integer		_nu_headers;

		std::map<Integer, String>	_headers;
		std::map<String, String>	_other_headers;

		std::map<Byte, String>		_attributes;
		std::map<String, String>	_other_attributes;
	};

    } // namespace ajp13
  } // namespace net
} // namespace sl

#endif // SL_NET_AJP13_FORWARD_REQUEST_PACKET_H
