/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: end_response_packet.h,v 1.3 2006/10/28 16:05:57 cvsuser Exp $
 */

#ifndef SL_NET_AJP13_END_RESPONSE_PACKET_H
#define SL_NET_AJP13_END_RESPONSE_PACKET_H

#include "packet.h"

namespace sl {
  namespace net {
    namespace ajp13 {

	class ajp13_error;

	/**
	 * WEBСؤΥ쥹ݥ󥹥ѥå
	 * (send_headers_packet ڤ send_body_chunk_packet)
	 * ³쥹ݥ󥹤νλ򼨤ѥåȤǤ.
	 * ǡȤBoolean(reuse)True֤ΥѥåȤȡ
	 * WEBФϼΥꥯˤΥѥåȤåȤѤ
	 * False֤ΥѥåȤȡWEBСϼΥꥯȤ
	 * ̤ΥåȤǹԤޤ.
	 * ǥեȤǤFalseꤵޤ.
	 */
	class end_response_packet : public packet {
	public :
		end_response_packet() : _reuse(false) { }

		Byte prefix_code() const;

		virtual packet &operator=(const ByteArray &array)
			throw(ajp13_error);

		operator ByteArray() const;

		Integer size() const;

		/**
		 * 쥹ݥ reuse ꤷޤ.
		 * @param	r	reuseꤹBoolean.
		 */
		void reuse(Boolean r);

		/**
		 * 쥹ݥ reuse ꤷޤ.
		 * @return	reuseꤵƤBoolean.
		 */
		Boolean reuse() const;

		void clear();

	private :
		Boolean _reuse;
	};

    } // namespace ajp13
  } // namespace net
} // namespace sl

#endif // SL_NET_AJP13_END_RESPONSE_PACKET_H
