/*-
 * Copyright (c) 2008 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_MANGLE_MANGLE_HPP
#define SL_MANGLE_MANGLE_HPP

#include <stdexcept>
#include <string>
#include <sl/config.hpp>
#include <sl/mangle/itanium/mangler.hpp>

namespace sl {

/**
 * ̾Υޥ󥰥.
 *
 * @param ʸ.
 * @return ޥ󥰥η̾.
 */
inline std::string mangle(const std::string& s)
{
    if (sl::config::compiler.compare(0, 3, "g++") ||
        sl::config::compiler.compare(0, 3, "gcc") ||
        sl::config::compiler.compare(0, 4, "icpc")||
        sl::config::compiler.compare(0, 3, "icc"))
        return mangler::mangle_itanium(s);
    else
        throw std::runtime_error("mangle failed. not implement.");
}

} // namespace sl

#endif // SI_MANGLE_HPP
