/*-
 * Copyright (c) 2008 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_MANGLE_ITANIUM_STATE_HPP
#define SL_MANGLE_ITANIUM_STATE_HPP

#include <deque>
#include <ostream>
#include <string>

namespace sl {

struct state {
    typedef std::deque<std::string> stack_type;

    state() : _type_end(0) {}

    stack_type _stack;
    stack_type _encoded;
    stack_type _cmp_S;           // compression Sn_
    stack_type _cmp_T;           // compression Tn_
    std::string _encode_name;
    std::string _prev_word;
    size_t _type_end;
};

inline std::ostream& operator<<(std::ostream& os, state& s)
{
    os << "prev_word  :" << s._prev_word << std::endl;
    os << "type_end   :" << s._type_end << std::endl;

    os << "stack      :";
    state::stack_type::const_iterator i = s._stack.begin();
    for (; i != s._stack.end(); i++)
        os << *i << " ";
    os << std::endl;

    os << "encoded    :";
    for (i = s._encoded.begin(); i != s._encoded.end(); i++)
        os << *i << " ";
    os << std::endl;

    os << "subs_S     :";
    for (i = s._cmp_S.begin(); i != s._cmp_S.end(); i++)
        os << *i << " ";
    os << std::endl;

    os << "subs_T     :";
    for (i = s._cmp_T.begin(); i != s._cmp_T.end(); i++)
        os << *i << " ";
    os << std::endl;

    return os;
}

} // namespace sl


#endif // SL_MANGLE_ITANIUM_STATE_HPP
